<?php
header('Access-Control-Allow-Origin: *');
header('Content-type: application/json');
include 'connect.php';
include 'class.upload.php';
error_reporting(0);

############ Configuration ##############
$max_image_size 		= 3000; //Maximum image size (height and width)
$destination_folder		= '../images/'; //upload directory ends with / (slash)
$jpeg_quality 			= 100; //jpeg quality

$mls_number=$_POST['mls_number']; 
$mtx_unq_number=$_POST['mtx_unq_number']; 
$agent_unique_id=$_POST['agent_unique_id']; 
$company_unique_id=$_POST['company_unique_id'];

$sqlPPTY="SELECT PicturesMain,PicturesHigh,PicturesMedium,PicturesTotal FROM listings WHERE MatrixUniqueNumber='$mtx_unq_number'"; 
$pptyRslt=mysqli_query($conn,$sqlPPTY) or die(mysqli_error($conn));
$pptyExist=mysqli_num_rows($pptyRslt); 
if($pptyExist>0){
$row=mysqli_fetch_array($pptyRslt);
$PicturesMain=$row['PicturesMain'];
$PicturesHigh=$row['PicturesHigh'];
$PicturesMedium=$row['PicturesMedium'];
$PicturesTotal=$row['PicturesTotal']; 

if(isset($_FILES['file'])!='' && is_uploaded_file($_FILES['file']['tmp_name'])){ /** using uploaded image **/
########################################## 
    
    //uploaded file info we need to proceed
    $image_name = $_FILES['file']['name']; //file name
    $image_size = $_FILES['file']['size']; //file size
    $image_temp = $_FILES['file']['tmp_name']; //file temp
    
    $image_size_info = getimagesize($image_temp); //get image size
    
    if($image_size_info){
    	$image_width 		= $image_size_info[0]; //image width
    	$image_height 		= $image_size_info[1]; //image height
    	$image_type 		= $image_size_info['mime']; //image type
        
        if($image_width<600 || $image_height<600){
        $restlArray=array('data'=>'Error: minimum image dimention required is <b>600px By 600px</b>'); 
        echo json_encode($restlArray);
        die();  
        }
    }else{
        $restlArray=array('data'=>'Make sure image file is valid!'); 
        echo json_encode($restlArray);
        die();  
    }
    
    //switch statement below checks allowed image type 
    //as well as creates new image from given file 
    switch($image_type){
    	case 'image/png':
    		$image_res =  imagecreatefrompng($image_temp); imagealphablending($image_res, true); imagesavealpha($image_res, true); break;
    	case 'image/gif':
    		$image_res =  imagecreatefromgif($image_temp); break;			
    	case 'image/jpeg':
    		$image_res = imagecreatefromjpeg($image_temp); break;
        case 'image/pjpeg':
    		$image_res = imagecreatefromjpeg($image_temp); break;
        case 'image/jpg':
    		$image_res = imagecreatefromjpeg($image_temp); break;
    	default:
    		$image_res = false;
    }

if($image_res){
    //Get file extension and name to construct new file name 
    $image_info = pathinfo($image_name);
    $image_extension = strtolower($image_info["extension"]); //image extension
    $image_name_only = strtolower($image_info["filename"]);//file name only, no extension
    $image_name_only = preg_replace('#[^A-Za-z0-9-_]#', '', $image_name_only);
    
    $time=time(); 
    $rand=rand(100000,10000000);
    $file_name = $mtx_unq_number.'-'.$time.'-'.$rand;
    $new_file_name = $file_name.'-high.'.$image_extension;
    
    //folder path to save resized images and thumbnails 
    $image_save_folder = $destination_folder.$new_file_name; 
     
    if(normal_resize_image($image_res, $image_save_folder, $image_type, $max_image_size, $image_width, $image_height, $jpeg_quality)){
    
    $handleM = new upload($image_save_folder); 
    if($handleM->uploaded){
      $handleM->file_new_name_body   = $file_name.'-medium'; /** no extension **/
      $handleM->image_resize         = true;
      $handleM->image_x              = 600;
      $handleM->image_ratio_y        = true;
      $handleM->process($destination_folder); 
    }
    
    if($PicturesTotal==0){ /** first pix to upload **/
    $handleD = new upload($image_save_folder); 
    if($handleD->uploaded){
      $handleD->file_new_name_body   = $file_name.'-main'; /** no extension **/
      $handleD->image_resize         = true;
      $handleD->image_y              = 300;
      $handleD->image_ratio_x        = true;
      $handleD->process($destination_folder); 
      
      $mainPix=$destination_folder.$file_name.'-main';
      $data = getimagesize($mainPix.'.'.$image_extension);
      $imgWidth = $data[0];
     
      $dfltMain=str_replace('../images/','',$mainPix);
      $upFeild=", PicturesMain='$dfltMain.$image_extension'";
    }
    
    }else{
    $upFeild='';    
    }
    
    $PicturesHigh.='{'.$new_file_name.'}';
    $PicturesMedium.='{'.$file_name.'-medium.'.$image_extension.'}';
    $PicturesTotal+=1;
    
    $update="UPDATE listings SET PicturesHigh='$PicturesHigh', PicturesMedium='$PicturesMedium'$upFeild, PicturesTotal='$PicturesTotal' WHERE MLSNumber='$mls_number' AND MatrixUniqueNumber='$mtx_unq_number' AND company_unique_id='$company_unique_id'";
    $upRslt=mysqli_query($conn,$update) or die(mysqli_error($conn));
     
    if($upRslt){   
    $restlArray=array('data'=>'Done', 'file_id'=>$PicturesTotal, 'file_name'=>$new_file_name);   
    }else{
    $restlArray=array('data'=>'Error updating details...try again');  
    } 
    echo json_encode($restlArray);
    
    }
    
    imagedestroy($image_res); //freeup memory
        
}  

}else{
    $restlArray=array('data'=>'Error: missing data');  
    echo json_encode($restlArray); die;
}

}else{
    $restlArray=array('data'=>'Error: listing not found');  
    echo json_encode($restlArray); die;
}

#####  This function will proportionally resize image ##### 
function normal_resize_image($source, $destination, $image_type, $max_size, $image_width, $image_height, $quality){
	
	if($image_width <= 0 || $image_height <= 0){return false;} //return false if nothing to resize
	
	//do not resize if image is smaller than max size
	if($image_width <= $max_size && $image_height <= $max_size){
		if(save_image($source, $destination, $image_type, $quality)){
			return true;
		}
	}
	
	//Construct a proportional size of new image
	$image_scale	= min($max_size/$image_width, $max_size/$image_height);
	$new_width		= ceil($image_scale * $image_width);
	$new_height		= ceil($image_scale * $image_height); 
	
	$new_canvas		= imagecreatetruecolor( $new_width, $new_height ); //Create a new true color image
	
	//Copy and resize part of an image with resampling
	if(imagecopyresampled($new_canvas, $source, 0, 0, 0, 0, $new_width, $new_height, $image_width, $image_height)){
		save_image($new_canvas, $destination, $image_type, $quality); //save resized image
	}

	return true;
}

##### Saves image resource to file ##### 
function save_image($source, $destination, $image_type, $quality){
	switch(strtolower($image_type)){//determine mime type
		case 'image/png': 
			imagepng($source, $destination); return true; //save png file
			break;
		case 'image/gif': 
			imagegif($source, $destination); return true; //save gif file
			break;          
		case 'image/jpeg':
			imagejpeg($source, $destination, $quality); return true; //save jpeg file
			break;
        case 'image/pjpeg':
			imagejpeg($source, $destination, $quality); return true; //save jpeg file
			break;
        case 'image/jpg':
    		imagejpeg($source, $destination, $quality); return true; //save jpeg file
    		break;
		default: return false;
	}
}
?>