<?php
header('Access-Control-Allow-Origin: *');
header('Content-type: application/json');
include 'connect.php';  

function number_format_short( $n, $precision = 1 ) {
if ($n < 900) {
	// 0 - 900
	$n_format = number_format($n, $precision);
	$suffix = '';
} else if ($n < 1000000) {
	// 0.9k-850k
	$n_format = number_format(floor($n / 1000), $precision);
	$suffix = 'K';
} else if ($n < 900000000) {
	// 0.9m-850m
	$n_format = number_format($n / 1000000, $precision);
	$suffix = 'M';
} 
// Remove unecessary zeroes after decimal. "1.0" -> "1"; "1.00" -> "1"
// Intentionally does not affect partials, eg "1.50" -> "1.50"
if ( $precision > 0 ) {
	$dotzero = '.' . str_repeat( '0', $precision );
	$n_format = str_replace( $dotzero, '', $n_format );
}
return $n_format . $suffix;
}

function number_format_Ms( $n, $precision = 2 ) {
if ($n < 9999) {
	// 0 - 900
	$n_format = number_format($n, $precision);
	$suffix = '';
} else if ($n < 1000000) {
	// 0.9k-850k
	//$n_format = number_format($n / 1000, $precision);
	$n_format = floatval($n / 1000);
    $n_format = substr($n_format, 0, 3);
	$suffix = 'K';
} else if ($n < 999999999) {
	// 0.9m-850m
	//$n_format = number_format($n / 1000000, $precision);
	$n_format = floatval($n / 1000000);
    $n_format = substr($n_format, 0, 3);
	$suffix = 'M';
} else if ($n < 999999999999) {
	$n_format = floatval($n / 1000000000);
    $n_format = substr($n_format, 0, 4);
	$suffix = 'B';
} else{
    $n_format = floatval($n / 1000000000000);
    $n_format = substr($n_format, 0, 5);
	$suffix = 'T';
}


// Remove unecessary zeroes after decimal. "1.0" -> "1"; "1.00" -> "1"
// Intentionally does not affect partials, eg "1.50" -> "1.50"
if ( $precision > 0 ) {
	$dotzero = '.' . str_repeat( '0', $precision );
	$n_format = str_replace( $dotzero, '', $n_format );
}
return $n_format.$suffix;
}

if(isset($_POST['agent_id']) && isset($_POST['company_unique_id']) && isset($_POST['system_access'])){  
    $agent_id=$_POST['agent_id'];
    $company_unique_id=$_POST['company_unique_id'];
    $system_access=$_POST['system_access']; 
    
    $checkStatus="SELECT status FROM agents WHERE agent_id='$agent_id' AND status='Active' "; 
    $statusRslt=mysqli_query($conn,$checkStatus) or die(mysqli_error($conn));
    $agentExist=mysqli_num_rows($statusRslt); 
    if($agentExist>0){
    
    //SELECT * FROM projects WHERE YEAR(Date) = 2011 AND MONTH(Date) = 5
        
    $selAccounts = "SELECT (SELECT COUNT(status) FROM listings WHERE status='Active' AND company_unique_id='$company_unique_id') as Active, 
                           (SELECT COUNT(status) FROM listings WHERE status='Pending' AND company_unique_id='$company_unique_id') as Pending, 
                           (SELECT COUNT(status) FROM listings WHERE status='Unpublished' AND company_unique_id='$company_unique_id') as Unpublished, 
                           (SELECT COUNT(status) FROM listings WHERE status='Expired' AND company_unique_id='$company_unique_id') as Expired, 
                           (SELECT COUNT(status) FROM listings WHERE status='Closed' AND company_unique_id='$company_unique_id') as Closed, 
                           (SELECT COUNT(status) FROM listings WHERE status='Cancelled' AND company_unique_id='$company_unique_id') as Cancelled, 
                           (SELECT COUNT(request_id) FROM sales_validation_requests WHERE co_selling_company_id='$company_unique_id' AND status='Pending') as SalesValidation";
                   
    $accntRslt=mysqli_query($conn,$selAccounts) or die(mysqli_error($conn));
    $accntExist=mysqli_num_rows($accntRslt);
    
    $checkAds="SELECT (SELECT COUNT(ads_view_id) FROM ads_views WHERE listing_company_id='$company_unique_id' AND ads_type='Featured' AND view_date >= (NOW() - INTERVAL 7 DAY)) as mFeaturedSvn, 
                      (SELECT COUNT(ads_view_id) FROM ads_views WHERE listing_company_id='$company_unique_id' AND ads_type='Sidebar' AND view_date >= (NOW() - INTERVAL 7 DAY)) as mSidebarSvn, 
                      (SELECT COUNT(ads_view_id) FROM ads_views WHERE listing_company_id='$company_unique_id' AND ads_type='Featured' AND view_date >= (NOW() - INTERVAL 30 DAY)) as mFeaturedTrty, 
                      (SELECT COUNT(ads_view_id) FROM ads_views WHERE listing_company_id='$company_unique_id' AND ads_type='Sidebar' AND view_date >= (NOW() - INTERVAL 30 DAY)) as mSidebarTrty, 
                      (SELECT COUNT(ads_view_id) FROM ads_views WHERE ref_company_id='$company_unique_id' AND ads_type='Featured' AND view_date >= (NOW() - INTERVAL 7 DAY)) as rFeaturedSvn, 
                      (SELECT COUNT(ads_view_id) FROM ads_views WHERE ref_company_id='$company_unique_id' AND ads_type='Sidebar' AND view_date >= (NOW() - INTERVAL 7 DAY)) as rSidebarSvn,
                      (SELECT COUNT(ads_view_id) FROM ads_views WHERE ref_company_id='$company_unique_id' AND ads_type='Featured' AND view_date >= (NOW() - INTERVAL 30 DAY)) as rFeaturedTrty, 
                      (SELECT COUNT(ads_view_id) FROM ads_views WHERE ref_company_id='$company_unique_id' AND ads_type='Sidebar' AND view_date >= (NOW() - INTERVAL 30 DAY)) as rSidebarTrty"; 
    $adsRslt=mysqli_query($conn,$checkAds) or die(mysqli_error($conn));
    
    $sum_TotalOrganicViews_Own = 0; $sum_TotalPaidViews_Own = 0; $sum_TotalOrganicViews_Others = 0; $sum_TotalPaidViews_Others = 0; 
    
    $checkViews="SELECT TotalOrganicViews_Own, TotalPaidViews_Own, TotalOrganicViews_Others, TotalPaidViews_Others FROM listings WHERE company_unique_id='$company_unique_id'"; 
    $viewRslt=mysqli_query($conn,$checkViews) or die(mysqli_error($conn));
    while($rowV=mysqli_fetch_array($viewRslt)){
       $TotalOrganicViews_Own = $rowV['TotalOrganicViews_Own'];
       $TotalPaidViews_Own = $rowV['TotalPaidViews_Own'];
       $TotalOrganicViews_Others = $rowV['TotalOrganicViews_Others'];
       $TotalPaidViews_Others = $rowV['TotalPaidViews_Others'];
       
       $sum_TotalOrganicViews_Own+=intval($TotalOrganicViews_Own);
       $sum_TotalPaidViews_Own+=intval($TotalPaidViews_Own);
       $sum_TotalOrganicViews_Others+=intval($TotalOrganicViews_Others);
       $sum_TotalPaidViews_Others+=intval($TotalPaidViews_Others);
    }
    
    $currentYear = date("Y");
    $sqlMyConv="SELECT closing_price FROM closed_sales WHERE listing_company_id='$company_unique_id' AND YEAR(closing_date) = $currentYear "; 
    $myConvRslt=mysqli_query($conn,$sqlMyConv) or die(mysqli_error($conn));
    $myConvExist=mysqli_num_rows($myConvRslt);
    $myConversion = 0;
    if($myConvExist>0){
    while($rowMy = mysqli_fetch_array($myConvRslt)){
        $my_closing_price = $rowMy['closing_price'];
        $my_closing_price = str_replace('.00','',$my_closing_price);
        $my_closing_price = str_replace(',','',$my_closing_price);
        $my_closing_price = str_replace('N','',$my_closing_price);
        $my_closing_price = trim(intval($my_closing_price));
        $myConversion += $my_closing_price;
    }
    }
    
    $sqlRevConv="SELECT closing_price FROM closed_sales WHERE co_selling_company_id='$company_unique_id' AND YEAR(closing_date) = $currentYear "; 
    $revConvRslt=mysqli_query($conn,$sqlRevConv) or die(mysqli_error($conn));
    $revConvExist=mysqli_num_rows($revConvRslt);
    $revenueConversion = 0;
    if($revConvExist>0){
    while($rowRv = mysqli_fetch_array($revConvRslt)){
        $rv_closing_price = $rowRv['closing_price'];
        $rv_closing_price = str_replace('.00','',$rv_closing_price);
        $rv_closing_price = str_replace(',','',$rv_closing_price);
        $rv_closing_price = str_replace('N','',$rv_closing_price);
        $rv_closing_price = trim(intval($rv_closing_price));
        $revenueConversion += $rv_closing_price;
    }
    }
    
    if($myConversion>99999999){
        $myConversion = number_format_Ms($myConversion);
    }else{
        $myConversion = number_format($myConversion,2);
    }
    
    if($revenueConversion>99999999){
        $revenueConversion = number_format_Ms($revenueConversion);
    }else{
        $revenueConversion = number_format($revenueConversion,2);
    }
    
    if($accntExist>0){  
        
    $row=mysqli_fetch_array($accntRslt);
    extract($row); 
    
    $totalOwnViews = intval($sum_TotalOrganicViews_Own + $sum_TotalPaidViews_Own);
    $totalOthersViews = intval($sum_TotalOrganicViews_Others + $sum_TotalPaidViews_Others);
    
    $OrganicOwnPrcnt = (100/$totalOwnViews) * $sum_TotalOrganicViews_Own;
    $PaidOwnPrcnt = (100/$totalOwnViews) * $sum_TotalPaidViews_Own;
    
    $OrganicOthersPrcnt = (100/$totalOthersViews) * $sum_TotalOrganicViews_Others;
    $PaidOthersPrcnt = (100/$totalOthersViews) * $sum_TotalPaidViews_Others;
    
    $rowAds=mysqli_fetch_array($adsRslt);
    extract($rowAds);
    
    $restlArray=array(
    'data'=>"Done",
    'active'=>$Active,
    'pending'=>$Pending,
    'unpublished'=>$Unpublished,
    'expired'=>$Expired,
    'closed'=>$Closed,
    'cancelled'=>$Cancelled,
    'SalesValidation'=>$SalesValidation,
    'TotalOrganicViews_Own'=>$sum_TotalOrganicViews_Own,
    'TotalPaidViews_Own'=>$sum_TotalPaidViews_Own,
    'TotalOrganicViews_Others'=>$sum_TotalOrganicViews_Others,
    'TotalPaidViews_Others'=>$sum_TotalPaidViews_Others,
    'Short_TotalOrganicViews_Own'=>number_format_Ms($sum_TotalOrganicViews_Own),
    'Short_TotalPaidViews_Own'=>number_format_Ms($sum_TotalPaidViews_Own),
    'Short_TotalOrganicViews_Others'=>number_format_Ms($sum_TotalOrganicViews_Others),
    'Short_TotalPaidViews_Others'=>number_format_Ms($sum_TotalPaidViews_Others),
    'OrganicOwnPrcnt'=>number_format($OrganicOwnPrcnt,2),
    'PaidOwnPrcnt'=>number_format($PaidOwnPrcnt,2),
    'OrganicOthersPrcnt'=>number_format($OrganicOthersPrcnt,2),
    'PaidOthersPrcnt'=>number_format($PaidOthersPrcnt,2),
    'my_last_7_Featured_views'=>$mFeaturedSvn,
    'my_last_7_Sidebar_views'=>$mSidebarSvn,
    'my_last_30_Featured_views'=>$mFeaturedTrty,
    'my_last_30_Sidebar_views'=>$mSidebarTrty,
    'rev_last_7_Featured_views'=>$rFeaturedSvn,
    'rev_last_7_Sidebar_views'=>$rSidebarSvn,
    'rev_last_30_Featured_views'=>$rFeaturedTrty,
    'rev_last_30_Sidebar_views'=>$rSidebarTrty,
    'myConversion'=>$myConversion,
    'revenueConversion'=>$revenueConversion
    );
     
    echo json_encode($restlArray);
    
    }else{ 
    $restlArray=array(
    'data'=>"No account found"
    );
    echo json_encode($restlArray);    
    }
     
    
    }else{
    $restlArray=array('data'=>'Operation Not Allowed'); 
    echo json_encode($restlArray);     
    }
}else{
    $restlArray=array('data'=>'Error receiving all required data'); 
    echo json_encode($restlArray); 
}
?>