<?php
header('Access-Control-Allow-Origin: *');
header('Content-type: application/json');
include 'connect.php';  

function number_format_short( $n, $precision = 1 ) {
if ($n < 900) {
	// 0 - 900
	$n_format = number_format($n, $precision);
	$suffix = '';
} else if ($n < 1000000) {
	// 0.9k-850k
	$n_format = number_format(floor($n / 1000), $precision);
	$suffix = 'K';
} else if ($n < 900000000) {
	// 0.9m-850m
	$n_format = number_format($n / 1000000, $precision);
	$suffix = 'M';
} 
// Remove unecessary zeroes after decimal. "1.0" -> "1"; "1.00" -> "1"
// Intentionally does not affect partials, eg "1.50" -> "1.50"
if ( $precision > 0 ) {
	$dotzero = '.' . str_repeat( '0', $precision );
	$n_format = str_replace( $dotzero, '', $n_format );
}
return $n_format . $suffix;
}

function number_format_Ms( $n, $precision = 2 ) {
if ($n < 900) {
	// 0 - 900
	$n_format = number_format($n, $precision);
	$suffix = '';
} else if ($n < 1000000) {
	// 0.9k-850k
	//$n_format = number_format($n / 1000, $precision);
	$n_format = floatval($n / 1000);
    $n_format = substr($n_format, 0, 5);
	$suffix = 'K';
} else if ($n < 900000000) {
	// 0.9m-850m
	//$n_format = number_format($n / 1000000, $precision);
	$n_format = floatval($n / 1000000);
    $n_format = substr($n_format, 0, 5);
	$suffix = 'M';
} 
// Remove unecessary zeroes after decimal. "1.0" -> "1"; "1.00" -> "1"
// Intentionally does not affect partials, eg "1.50" -> "1.50"
if ( $precision > 0 ) {
	$dotzero = '.' . str_repeat( '0', $precision );
	$n_format = str_replace( $dotzero, '', $n_format );
}
return $n_format.$suffix;
}

if(isset($_POST['type']) && isset($_POST['limit']) && isset($_POST['page'])){
    
    $type=$_POST['type'];
    $browser=$_POST['browser'];

    if($type=='All'){  
    $limit=$_POST['limit'];
    $featured=$_POST['featured'];  
    $xmls_number=$_POST['mls_number']; 
    $location=$_POST['location'];
    $property_type=$_POST["property_type"]; 
    $min_price=$_POST["min_price"];  
    $max_price=$_POST["max_price"];  
    $bedrooms=$_POST["beds"];  
    $bathrooms=$_POST["baths"];     
    $min_sq_ft=$_POST["min_sq_ft"]; 
    $max_sq_ft=$_POST["max_sq_ft"]; 
    $min_year=$_POST["min_year"]; 
    $max_year=$_POST["max_year"]; 
    $stories=$_POST["stories"]; 
    $garage=$_POST["garage"]; 
    $shortlet=$_POST["shortlet"];   
    $pool=$_POST["pool"];   
    $ac=$_POST["ac"];   
    $security=$_POST["security"];   
    $handicap=$_POST["handicap"];
    $waterfront=$_POST["waterfront"];  
    $sort_by=$_POST["sort"]; 
    $pagination=$_POST["pagination"];
    $location=str_replace(' state','',$location);
    $location=str_replace(' State','',$location);
    $location=str_replace(' State','',$location);
    $location=trim($location);
    
    if(isset($_POST["page"])){
    $page=$_POST["page"];
    }else{
    $page=1;
    }
   
    if($location!='Any'){
      $qry_loc=" (City LIKE '%$location%' OR State LIKE '%$location%' OR SubLocality LIKE '%$location%')";  
    }else{
      $qry_loc=" city!='0' "; /** since city could be empty **/ 
    } 
    
    
    if($property_type!='Any'){
      $property_type=explode(',',$property_type);
      $PropertyType=$property_type[0];
      $constructionType=$property_type[1];
      
      if($constructionType!='Any'){
      $qry_type=" AND PropertyType='$PropertyType' AND constructionType='$constructionType' ";
      }else{
      $qry_type=" AND PropertyType='$PropertyType' ";  
      }
    }else{
      $PropertyType='Any';
      $constructionType='Any';
      $qry_type=""; 
    } 
        
    if($bedrooms!='Any' && $bedrooms!=''){ 
      if(strpos($bedrooms, '+') !== false){
        $bedz=str_replace('+','',$bedrooms);
        $qry_beds=" AND TotalBedrooms>=$bedz"; 
      }else{
        $qry_beds=" AND TotalBedrooms=$bedrooms"; 
      }  
    }else{
      $qry_beds="";  
    }
    
    if($bathrooms!='Any' && $bathrooms!=''){
      if(strpos($bathrooms, '+') !== false){
        $bathz=str_replace('+','',$bathrooms);
        $qry_baths=" AND BathroomsFull>=$bathz"; 
      }else{
        $qry_baths=" AND BathroomsFull=$bathrooms"; 
      }
        
    }else{
      $qry_baths="";  
    } 
     
    if(($min_price!='Any' && $min_price!='') && ($max_price=='Any')){
     $qry_min_max_pri_join=" AND list_price>=$min_price"; 
    }else if(($min_price=='Any') && ($max_price!='Any' && $max_price!='')){
     $qry_min_max_pri_join=" AND list_price<=$max_price"; 
    }else if($min_price!='Any' && $max_price!='Any' && $min_price!='' && $max_price!=''){
     $qry_min_max_pri_join=" AND (list_price>=$min_price AND list_price<=$max_price)";   
    }else if($min_price=='' && ($max_price!='Any' && $max_price!='')){
     $qry_min_max_pri_join=" AND list_price<=$max_price";   
    }else if(($min_price!='Any' && $min_price!='') && $max_price==''){
     $qry_min_max_pri_join=" AND list_price>=$min_price";   
    }else{
     $qry_min_max_pri_join='';   
    }
     
    if(($min_sq_ft!='Any' && $min_sq_ft!='') && ($max_sq_ft=='Any')){
     $qry_lot_size=" AND SqFtTotal>=$min_sq_ft"; 
    }else if(($min_sq_ft=='Any') && ($max_sq_ft!='Any' && $max_sq_ft!='')){
     $qry_lot_size=" AND SqFtTotal<=$max_sq_ft"; 
    }else if(($min_sq_ft!='Any') && ($max_sq_ft!='Any') && ($min_sq_ft!='') && ($max_sq_ft!='')){
     $qry_lot_size=" AND (SqFtTotal>=$min_sq_ft AND SqFtTotal<=$max_sq_ft)";   
    }else if($min_sq_ft=='' && ($max_sq_ft!='Any' && $max_sq_ft!='')){
     $qry_lot_size=" AND SqFtTotal<=$max_sq_ft";   
    }else if(($min_sq_ft!='Any' && $min_sq_ft!='') && $max_sq_ft==''){
     $qry_lot_size=" AND SqFtTotal>=$min_sq_ft";   
    }else{
     $qry_lot_size='';   
    }
    
    if(($min_year!='Any' && $min_year!='') && ($max_year=='Any')){
     $qry_year_built=" AND YearBuilt>=$min_year"; 
    }else if(($min_year=='Any') && ($max_year!='Any' && $max_year!='')){
     $qry_year_built=" AND YearBuilt<=$max_year"; 
    }else if(($min_year!='Any') && ($max_year!='Any') && ($min_year!='') && ($max_year!='')){
     $qry_year_built=" AND (YearBuilt>=$min_year AND YearBuilt<=$max_year)";   
    }else if($min_year=='' && ($max_year!='Any' && $max_year!='')){
     $qry_year_built=" AND YearBuilt<=$max_year";   
    }else if(($min_year!='Any' && $min_year!='') && $max_year==''){
     $qry_year_built=" AND YearBuilt>=$min_year";   
    }else{
     $qry_year_built='';   
    }
    
    
    if($garage!='Any' && $garage!=''){ 
      if(strpos($garage, '+') !== false){
        $garageX=str_replace('+','',$garage);
        $qry_garage=" AND GarageSpaces>=$garageX"; 
      }else{
        $qry_garage=" AND GarageSpaces=$garage"; 
      }  
    }else{
      $qry_garage="";  
    }
    
    
    if($stories!='Any' && $stories!=''){ 
      if(strpos($stories, '+') !== false){
        $storiz=str_replace('+','',$stories);
        $qry_stories=" AND NumberOfStories>=$storiz"; 
      }else{
        $qry_stories=" AND NumberOfStories=$stories"; 
      }  
    }else{
      $qry_stories="";  
    }
    
    
    if($shortlet=='Yes'){
      $qry_shortlet=" AND ShortLet='Yes'";  
    }else{
      $qry_shortlet="";  
    }
    
    if($ac=='Yes'){
      $qry_ac=" AND CoolingVal LIKE '%Wall-Win A/C%'";  
    }else{
      $qry_ac="";  
    }
    
    if($security=='Yes'){
      $qry_security=" AND (SecurityVal!='' AND SecurityVal!=',None,')";  
    }else{
      $qry_security="";  
    }
    
    if($pool=='Yes'){
      $qry_pool=" AND (PrivatePool='Yes' OR PrivatePoolVal!='')";  
    }else{
      $qry_pool="";  
    }
    
    if($handicap=='Yes'){
      $qry_handicap=" AND JONAPWDCompliantVal!=''";  
    }else{
      $qry_handicap="";  
    }
    
    
    if($sort_by=="sqft-asc"){
     $order_by="CAST(SqFtTotal as DECIMAL(10,5)) ASC";   
    }else if($sort_by=="sqft-desc"){
     $order_by="CAST(SqFtTotal as DECIMAL(10,5)) DESC";   
    }else if($sort_by=="lot-asc"){
     $order_by="CAST(LotSqFt as DECIMAL(10,5)) ASC";   
    }else if($sort_by=="lot-desc"){
     $order_by="CAST(LotSqFt as DECIMAL(10,5)) DESC";   
    }else if($sort_by=="baths-asc"){
     $order_by="CAST(BathroomsFull as DECIMAL) ASC";    
    }else if($sort_by=="baths-desc"){
     $order_by="CAST(BathroomsFull as DECIMAL) DESC";    
    }else if($sort_by=="beds-asc"){
     $order_by="CAST(TotalBedrooms as DECIMAL) ASC";    
    }else if($sort_by=="beds-desc"){
     $order_by="CAST(TotalBedrooms as DECIMAL) DESC";    
    }else if($sort_by=="garages-asc"){
     $order_by="CAST(GarageSpaces as DECIMAL) ASC";    
    }else if($sort_by=="garages-desc"){
     $order_by="CAST(GarageSpaces as DECIMAL) DESC";    
    }else if($sort_by=="price-asc"){
     $order_by="CAST(list_price as DECIMAL) ASC";   
    }else if($sort_by=="price-desc"){
     $order_by="CAST(list_price as DECIMAL) DESC";   
    }else{ /** not set **/
     $order_by="CAST(list_price as DECIMAL) ASC";   
    }
    
    /** if type is not residentials and rentals, no need for beds and baths check or swimming pool and other features **/
    if($xmls_number==''){
        
    if($PropertyType=='Land/Docks' && $PropertyType=='Commercial/Industry'){
      $query=$qry_loc.$qry_type.$qry_min_max_pri_join.$qry_lot_size." AND Status='Active'"; 
    }else if($PropertyType=='Residential Income'){
      $query=$qry_loc.$qry_type.$qry_garage.$qry_min_max_pri_join.$qry_lot_size.$qry_shortlet.$qry_ac.$qry_security.$qry_pool.$qry_handicap." AND Status='Active'"; 
    }else{
      $query=$qry_loc.$qry_type.$qry_beds.$qry_baths.$qry_garage.$qry_min_max_pri_join.$qry_lot_size.$qry_year_built.$qry_stories.$qry_shortlet.$qry_ac.$qry_security.$qry_pool.$qry_handicap." AND Status='Active'";
    }
    
    }else{ /** ignore other queries and seach mls number only **/
    $query=" MLSNumber='$xmls_number'";
    }
    
    
    /** insert search data **/
    /** insert search data **/
    /** Should be updated to another table "search_data_out" every 24 hours with cron job **/
    
    if($browser == 'Live'){
    if($location!='Any' && $min_price!='Any' && $max_price!='Any' && $property_type!='Any' && $bedrooms!='Any' && $bathrooms!='Any'){
    $date = date("Y-m-d");
    $addSearch="INSERT INTO search_data(location, min_price, max_price, property_type, beds, baths, garage, shortlet, date) 
    VALUES('$location', '$min_price', '$max_price', '$property_type', '$bedrooms', '$bathrooms', '$garage', '$shortlet', '$date')";
    $addSrchRslt=mysqli_query($conn,$addSearch) or die(mysqli_error($conn));
    }
    }
    
    /** insert search data **/
    /** insert search data **/
    
    
    $start_from = ($page-1) * $limit; 
    
    
    /** properties **/
    /** properties **/
    $sqlTotal="SELECT MLSNumber FROM listings WHERE $query ";
    $ttlRslt=mysqli_query($conn,$sqlTotal) or die(mysqli_error($conn));
    $total_records=mysqli_num_rows($ttlRslt);
    
    $resultHdr=$total_records;
    if($constructionType!='' && $constructionType!='Any'){ $resultHdr.=' '.$constructionType; }
    
    if($total_records>1){ $pptyTxt='properties'; }else{ $pptyTxt='property'; }
    if($location!='' && $location!='Any'){
        $resultHdr.=' '.$pptyTxt.' found in '.$location;
    }else{
        $resultHdr.=' '.$pptyTxt.' found';
    }
    
    $to_sel="MatrixUniqueNumber, MLSNumber, PropertyType, PropertyTitle, list_price, ForSale, ForLease, ShortLet, BathroomsFull, City, company_unique_id, GarageSpaces, LotSqFt, MapAddress, PicturesMain, State, StreetName, StreetNumber, SubLocality, SqFtTotal, TotalBedrooms";
    
    if($browser == 'Live'){
    $sqlPPTY="SELECT $to_sel FROM listings WHERE $query ORDER BY $order_by LIMIT $start_from, $limit";
    }else{ /** preview and web-builder. Could be empty for web-builder on initial load too **/
    $sqlPPTY="SELECT $to_sel FROM z_dummy_listings WHERE Status='Active' ORDER BY $order_by LIMIT $start_from, $limit";   
    }
    
    $pptyRslt=mysqli_query($conn,$sqlPPTY) or die(mysqli_error($conn));
    $pptyExist=mysqli_num_rows($pptyRslt); 
    if($pptyExist>0){
    
    while($row=mysqli_fetch_array($pptyRslt)){ 
    extract($row);
    
    $address=$StreetNumber.' '.$StreetName.' '.$SubLocality.', '.$City.', '.$State;
    
    $l_st_num=preg_replace("/[^0-9]/","",$StreetNumber);
    $l_st_nam=preg_replace("/[^A-Za-z]/","",$StreetName);
    $l_st_sub=preg_replace("/[^A-Za-z]/","",$SubLocality);
    $l_cty=preg_replace("/[^A-Za-z]/","",$City);
    $l_state=preg_replace("/[^A-Za-z]/","",$State);
                                          
    if($l_st_num!=''){                    
        $l_st_num=$l_st_num.'-';          
    }                                     
                                          
    if($l_st_nam!=''){                    
        $l_st_nam=$l_st_nam.'-';          
    }                                     
                                          
    if($l_st_sub!=''){      
        $l_st_sub=$l_st_sub.'-';          
    }                                    
                                          
    if($l_cty!=''){      
        $l_cty=$l_cty.'-';          
    }                                     
                                          
    $propertyLink=$l_st_num.$l_st_nam.$l_st_sub.$l_cty.$l_state;
    $propertyLink=strtolower($propertyLink);
    
    $pptyArray[]=array(
    'data'=>"Done", 
    'total_records'=>$total_records,
    'MatrixUniqueNumber'=>$MatrixUniqueNumber,
    'MLSNumber'=>$MLSNumber,
    'PropertyType'=>$PropertyType,
    'PropertyTitle'=>$PropertyTitle,
    'list_price'=>number_format($list_price,0),
    'ForSale'=>$ForSale,
    'ForLease'=>$ForLease,
    'ShortLet'=>$ShortLet,
    'BathroomsFull'=>$BathroomsFull,
    'listing_company_id'=>$company_unique_id,
    'City'=>$City,
    'GarageSpaces'=>$GarageSpaces,
    'PicturesMain'=>$PicturesMain,
    'LotSqFt'=>$LotSqFt,
    'MapAddress'=>$MapAddress,
    'State'=>$State,
    'StreetName'=>$StreetName,
    'StreetNumber'=>$StreetNumber,
    'SubLocality'=>$SubLocality,
    'Address'=>$address,
    'propertyLink'=>$propertyLink,
    'ResultHeader'=>$resultHdr,
    'SqFtTotal'=>$SqFtTotal,
    'TotalBedrooms'=>$TotalBedrooms
    );
    
    }
    /** properties **/
    /** properties **/ 
      
    }else{
    $pptyArray[]=array('data'=>'No listings to display on this page', 'total_records'=>0, 'ResultHeader'=>'');
    }
    
    
    
    
    /** Featured ads **/
    /** Featured ads **/
    if($browser == 'Live'){
        $ftrdTable = 'ads';
        $ftrdListngs = 'listings';
    }else{
        $ftrdTable = 'z_dummy_ads';
        $ftrdListngs = 'z_dummy_listings';
    }
    
    $checkAds="SELECT ads_id, mtx_unq_number FROM $ftrdTable WHERE ad_type='Featured' AND status='Active' AND (current_total_views <= maximum_views) AND daily_views_left > 0 ORDER BY rand() LIMIT $featured"; 
    $adsRslt=mysqli_query($conn,$checkAds) or die(mysqli_error($conn));
    $adsExist=mysqli_num_rows($adsRslt); 
    if($adsExist>0){  
        
    while($rowAds=mysqli_fetch_array($adsRslt)){ 
    $ads_id=$rowAds['ads_id'];
    $mtxUnqNumber=$rowAds['mtx_unq_number'];
    
    $sqlAdsPPTY="SELECT MatrixUniqueNumber, MLSNumber, PropertyType, PropertyTitle, list_price, ForSale, ForLease, ShortLet, BathroomsFull, City, company_unique_id, GarageSpaces, MapAddress, PicturesMain, State, StreetName, StreetNumber, SubLocality, SqFtTotal, TotalBedrooms FROM $ftrdListngs WHERE MatrixUniqueNumber='$mtxUnqNumber'"; 
    $adsPptyRslt=mysqli_query($conn,$sqlAdsPPTY) or die(mysqli_error($conn));
    $adsPptyExist=mysqli_num_rows($adsPptyRslt); 

    $Prow=mysqli_fetch_array($adsPptyRslt);
    $P_MatrixUniqueNumber=$Prow['MatrixUniqueNumber'];
    $P_MLSNumber=$Prow['MLSNumber'];
    $P_PropertyType=$Prow['PropertyType'];
    $P_PropertyTitle=$Prow['PropertyTitle'];
    $P_list_price=$Prow['list_price'];
    $P_ForSale=$Prow['ForSale'];
    $P_ForLease=$Prow['ForLease'];
    $P_ShortLet=$Prow['ShortLet'];
    $P_BathroomsFull=$Prow['BathroomsFull'];
    $P_listing_company_id=$Prow['company_unique_id'];
    $P_City=$Prow['City'];
    $P_GarageSpaces=$Prow['GarageSpaces'];
    $P_MapAddress=$Prow['MapAddress'];
    $P_PicturesMain=$Prow['PicturesMain'];
    $P_State=$Prow['State'];
    $P_StreetName=$Prow['StreetName'];
    $P_StreetNumber=$Prow['StreetNumber'];
    $P_SubLocality=$Prow['SubLocality'];
    $P_SqFtTotal=$Prow['SqFtTotal'];
    $P_TotalBedrooms=$Prow['TotalBedrooms'];
    
    $P_address=$P_StreetNumber.' '.$P_StreetName.' '.$P_SubLocality.', '.$P_City.', '.$P_State;
    
    $st_num=preg_replace("/[^0-9]/","",$P_StreetNumber);
    $st_nam=preg_replace("/[^A-Za-z]/","",$P_StreetName);
    $st_sub=preg_replace("/[^A-Za-z]/","",$P_SubLocality);
    $cty=preg_replace("/[^A-Za-z]/","",$P_City);
    $state=preg_replace("/[^A-Za-z]/","",$P_State);
                                          
    if($st_num!=''){                    
        $st_num=$st_num.'-';          
    }                                     
                                          
    if($st_nam!=''){                    
        $st_nam=$st_nam.'-';          
    }                                     
                                          
    if($st_sub!=''){      
        $st_sub=$st_sub.'-';          
    }                                    
                                          
    if($cty!=''){      
        $cty=$cty.'-';          
    }                                     
                                          
    $P_propertyLink=$st_num.$st_nam.$st_sub.$cty.$state;
    $P_propertyLink=strtolower($P_propertyLink);
    
    $adsArray[]=array(
    'data'=>"Done", 
    'ads_id'=>$ads_id,
    'MatrixUniqueNumber'=>$P_MatrixUniqueNumber,
    'MLSNumber'=>$P_MLSNumber,
    'PropertyType'=>$P_PropertyType,
    'PropertyTitle'=>$P_PropertyTitle,
    'list_price'=>number_format($P_list_price,0),
    'ForSale'=>$P_ForSale,
    'ForLease'=>$P_ForLease,
    'ShortLet'=>$P_ShortLet,
    'BathroomsFull'=>$P_BathroomsFull,
    'listing_company_id'=>$P_listing_company_id,
    'City'=>$P_City,
    'GarageSpaces'=>$P_GarageSpaces,
    'PicturesMain'=>$P_PicturesMain,
    'MapAddress'=>$P_MapAddress,
    'State'=>$P_State,
    'StreetName'=>$P_StreetName,
    'StreetNumber'=>$P_StreetNumber,
    'SubLocality'=>$P_SubLocality,
    'Address'=>$P_address,
    'propertyLink'=>$P_propertyLink,
    'SqFtTotal'=>$P_SqFtTotal,
    'TotalBedrooms'=>$P_TotalBedrooms
    );
    }
    
    }else{    
    $adsArray[]=array('data'=>'Ads not found', 'total_records'=>0, 'ResultHeader'=>'');   
    }
    /** Featured ads **/
    /** Featured ads **/ 
    
    
    $restlArray=array(
    'data'=>'Done',
    'ads'=>$adsArray,
    'properties'=>$pptyArray,
    'related'=>''
    );
    
    echo json_encode($restlArray);
    
    
    
    }else if($type=='Single'){
    
    $mls_number=$_POST['mls_number'];
    $related_limits=$_POST['related_limits'];
    $RelatedCity='';
    $RelatedState='';
    $feature_block_class = 'listing_detail col-xl-4 col-lg-6 col-md-6 col-sm-12 fleft dsply_inline_blck';
    
    $sqlPPTY="SELECT * FROM listings WHERE MLSNumber='$mls_number'";
    $pptyRslt=mysqli_query($conn,$sqlPPTY) or die(mysqli_error($conn));
    $pptyExist=mysqli_num_rows($pptyRslt); 
    if($pptyExist>0){
    
    $row=mysqli_fetch_array($pptyRslt);
    extract($row);
    
    $address=$StreetNumber.' '.$StreetName.' '.$SubLocality.', '.$City.', '.$State;
    
    $l_st_num=preg_replace("/[^0-9]/","",$StreetNumber);
    $l_st_nam=preg_replace("/[^A-Za-z]/","",$StreetName);
    $l_st_sub=preg_replace("/[^A-Za-z]/","",$SubLocality);
    $l_cty=preg_replace("/[^A-Za-z]/","",$City);
    $l_state=preg_replace("/[^A-Za-z]/","",$State);
                                          
    if($l_st_num!=''){                    
        $l_st_num=$l_st_num.'-';          
    }                                     
                                          
    if($l_st_nam!=''){                    
        $l_st_nam=$l_st_nam.'-';          
    }                                     
                                          
    if($l_st_sub!=''){      
        $l_st_sub=$l_st_sub.'-';          
    }                                    
                                          
    if($l_cty!=''){      
        $l_cty=$l_cty.'-';          
    }                                     
                                          
    $propertyLink=$l_st_num.$l_st_nam.$l_st_sub.$l_cty.$l_state;
    $propertyLink=strtolower($propertyLink);
    
    $GeneralDescription=array();
    $GenDescClass='listing_detail col-xl-4 col-lg-6 col-md-12 fleft dsply_inline_blck not_editable';
    if($PropertyType!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Property Type: </strong><span class="not_editable">'.$PropertyType.'</span></div>'); }
    if($constructionType!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Construction Type: </strong><span class="not_editable">'.$constructionType.'</span></div>'); }
    if($PropertyCondition!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Prop. Condition: </strong><span class="not_editable">'.$PropertyCondition.'</span></div>'); }
    if($TotalBedrooms!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Total Bedrooms: </strong><span class="not_editable">'.$TotalBedrooms.'</span></div>'); }
    if($NumberOfStories!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Number of Stories: </strong><span class="not_editable">'.$NumberOfStories.'</span></div>'); }
    if($BathroomsFull!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Bathrooms Full: </strong><span class="not_editable">'.$BathroomsFull.'</span></div>'); }
    if($BathroomsHalf!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Bathrooms Half: </strong><span class="not_editable">'.$BathroomsHalf.'</span></div>'); }
    if($YearBuilt!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Year Built: </strong><span class="not_editable">'.$YearBuilt.'</span></div>'); }
    if($SqFtTotal!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Sqm Total: </strong><span class="not_editable">'.number_format($SqFtTotal).' Sqm</span></div>'); }
    if($SqFtLiving!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Sqm Living Area: </strong><span class="not_editable">'.number_format($SqFtLiving).' Sqm</span></div>'); }
    if($TotalBuildingSqFt!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Total Building Sqm: </strong><span class="not_editable">'.number_format($TotalBuildingSqFt).' Sqm</span></div>'); }
    if($SqFtSource!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Sqm Source: </strong><span class="not_editable">'.$SqFtSource.'</span></div>'); }
    
    if($GuestHouse!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Guest House: </strong><span class="not_editable">'.$GuestHouse.'</span></div>'); }
    if($SqFtGuestHouse!='' && $GuestHouse=='Yes'){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Guest House Sqm: </strong><span class="not_editable">'.number_format($SqFtGuestHouse).' Sqm</span></div>'); }
    if($OpenParkingSpaces!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Open Parking Spaces: </strong><span class="not_editable">'.$OpenParkingSpaces.'</span></div>'); }
    if($GarageSpaces!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Garage Spaces: </strong><span class="not_editable">'.$GarageSpaces.'</span></div>'); }
    if($CarportSpaces!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Carport Spaces: </strong><span class="not_editable">'.$CarportSpaces.'</span></div>'); }
    if($HomeownersAssoc!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Home Owners Association: </strong><span class="not_editable">'.$HomeownersAssoc.'</span></div>'); }
    if($ApplicationFee!='' && $HomeownersAssoc!='None'){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">HOA Application Fee: </strong><span class="not_editable">'.$ApplicationFee.'</span></div>'); }
    if($HOA_POA_COA!='' && $HomeownersAssoc!='None'){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">HOA/POA/COA(Monthly): </strong><span class="not_editable">'.$HOA_POA_COA.'</span></div>'); }
    if($LotSqFt!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Plot/Lot Sqm: </strong><span class="not_editable">'.number_format($LotSqFt).' Sqm</span></div>'); }
    if($LotDimensions!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Plot/Lot Dimensions: </strong><span class="not_editable">'.$LotDimensions.'</span></div>'); }
    if($Dock!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Dock: </strong><span class="not_editable">'.$Dock.'</span></div>'); }
    
    if($PrivatePool!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Private Pool: </strong><span class="not_editable">'.$PrivatePool.'</span></div>'); }
    if($PetsAllowed!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Pets Allowed: </strong><span class="not_editable">'.$PetsAllowed.'</span></div>'); }
    if($TotalUnitsInComplex!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Total Units In Complex: </strong><span class="not_editable">'.$TotalUnitsInComplex.'</span></div>'); }
    if($TotalUnitsInBuilding!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Total Units In Building: </strong><span class="not_editable">'.$TotalUnitsInBuilding.'</span></div>'); }
    if($TotalFloorsStories!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Total Floors Stories: </strong><span class="not_editable">'.$TotalFloorsStories.'</span></div>'); }
    if($SeparateElectricityMeters!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Separate Electricity Meters: </strong><span class="not_editable">'.$SeparateElectricityMeters.'</span></div>'); }
    if($SeparateWaterMeters!=''){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Separate Water Meters: </strong><span class="not_editable">'.$SeparateWaterMeters.'</span></div>'); }
    
    
    if($PropertyDescription){ array_push($GeneralDescription,'<div class="'.$GenDescClass.'"><strong class="not_editable">Property Description: </strong><span class="not_editable">'.$PropertyDescription.'</span></div>'); }
    
    if($Unit1Info!='' || $Unit2Info!='' || $Unit3Info!='' || $Unit4Info!=''){
    
    /** Unit 1 Info **/
    /** Unit 1 Info **/
    if($Unit1Info!=''){
    $ExpU1 = explode('#', $Unit1Info); 
    $U1_Hotel=trim($ExpU1[1]);
    $U1_Efficiency=trim($ExpU1[2]);
    $U1_Bedrooms=trim($ExpU1[3]);
    $U1_BedroomsVal=trim($ExpU1[4]);
    $U1_FullBath=trim($ExpU1[5]);
    $U1_FullBathVal=trim($ExpU1[6]);
    $U1_HalfBath=trim($ExpU1[7]);
    $U1_HalfBathVal=trim($ExpU1[8]);
    $U1_Furnished=trim($ExpU1[9]);
    $U1_FurnishedVal=trim($ExpU1[10]);
    $U1_SqFt=trim($ExpU1[11]);
    $U1_SqFtVal=trim($ExpU1[12]);
    $U1_MonthlyIncome=trim($ExpU1[13]);
    $U1_MonthlyIncomeVal=trim($ExpU1[14]);
    $U1_LeaseEnds=trim($ExpU1[15]);
    $U1_LeaseEndsVal=trim($ExpU1[16]);
    
    $U1DescArr = explode(',', $U1Desc);
    asort($U1DescArr);
    
    $CountU1Dsc = 1;
    $U1_DscpVal='';
    
    foreach($U1DescArr as $U1_Desc){
    if($U1_Desc!=''){ 
        $U1_DscpVal.='<div class="'.$feature_block_class.' not_editable">
                     <i class="fas fa-check action-1 not_editable"></i> '.$U1_Desc.'
                     </div>';
        $CountU1Dsc++;   
    }
    }
    
    $U1_DscpVal='<div class="listing_detail_body w-100 fleft mb-10 not_editable">
                 <div class="listing_detail col-md-12 feature_block_Interior Details not_editable">
                 <div class="feature_chapter_name w-100 not_editable">Descriptions</div>
                 '.$U1_DscpVal.'
                 </div>
                 </div>';
    
    $U1PrkArr = explode(',', $U1Park);
    asort($U1PrkArr);
    
    $CountPrk = 1;
    $U1_PrkVal='';
    foreach($U1PrkArr as $U1_Park){
    if($U1_Park!=''){
        $U1_PrkVal.='<div class="'.$feature_block_class.' not_editable">
                     <i class="fas fa-check action-1 not_editable"></i> '.$U1_Park.'
                     </div>';
        $CountPrk++;   
    }
    }
    $U1_PrkVal='<div class="listing_detail_body w-100 fleft mb-10 not_editable">
                <div class="listing_detail col-md-12 feature_block_Interior_Details">
                <div class="feature_chapter_name w-100">Parking</div>
                '.$U1_PrkVal.'
                </div>
                </div>';
    
    $U1Info='<div class="w-100 fleft mb-25 not_editable">
             <div class="listing_detail_body w-100 fleft mb-10 not_editable">
             <div class="listing_detail col-md-12 feature_block_Interior_Details not_editable">
             <div class="feature_chapter_name w-100 fs-15 not_editable" style="color: #FF8D1C;">Unit 1 Info</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Hotel:</strong> '.str_replace('Hotel:','',$U1_Hotel).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Efficiency:</strong> '.str_replace('Efficiency:','',$U1_Efficiency).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Bedrooms:</strong> '.str_replace('BedroomsVal:','',$U1_BedroomsVal).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Full Bath:</strong> '.str_replace('FullBathVal:','',$U1_FullBathVal).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Half Bath:</strong> '.str_replace('HalfBathVal:','',$U1_HalfBathVal).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Furnished:</strong> '.str_replace('FurnishedVal:','',$U1_FurnishedVal).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Sqm:</strong> '.str_replace('SqFtVal:','',$U1_SqFtVal).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Monthly Income:</strong> '.str_replace('MonthlyIncomeVal:','',$U1_MonthlyIncomeVal).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Lease Ends:</strong> '.str_replace('LeaseEndsVal:','',$U1_LeaseEndsVal).'</div>
             </div>
             </div>
            
             '.$U1_DscpVal.'
             '.$U1_PrkVal.'
             </div>';
    }else{
        $U1Info = '';
    }
    /** Unit 1 Info **/
    /** Unit 1 Info **/
    
    
    
    
    /** Unit 2 Info **/
    /** Unit 2 Info **/
    if($Unit2Info!=''){
    $ExpU2 = explode('#', $Unit2Info); 
    $U2_Hotel=trim($ExpU2[1]);
    $U2_Efficiency=trim($ExpU2[2]);
    $U2_Bedrooms=trim($ExpU2[3]);
    $U2_BedroomsVal=trim($ExpU2[4]);
    $U2_FullBath=trim($ExpU2[5]);
    $U2_FullBathVal=trim($ExpU2[6]);
    $U2_HalfBath=trim($ExpU2[7]);
    $U2_HalfBathVal=trim($ExpU2[8]);
    $U2_Furnished=trim($ExpU2[9]);
    $U2_FurnishedVal=trim($ExpU2[10]);
    $U2_SqFt=trim($ExpU2[11]);
    $U2_SqFtVal=trim($ExpU2[12]);
    $U2_MonthlyIncome=trim($ExpU2[13]);
    $U2_MonthlyIncomeVal=trim($ExpU2[14]);
    $U2_LeaseEnds=trim($ExpU2[15]);
    $U2_LeaseEndsVal=trim($ExpU2[16]);
    
    $U2DescArr = explode(',', $U2Desc);
    asort($U2DescArr);
    
    $CountU2Dsc = 1;
    $U2_DscpVal='';
    
    foreach($U2DescArr as $U2_Desc){
    if($U2_Desc!=''){ 
        $U2_DscpVal.='<div class="'.$feature_block_class.' not_editable">
                     <i class="fas fa-check action-1 not_editable"></i> '.$U2_Desc.'
                     </div>';
        $CountU2Dsc++;   
    }
    }
    
    $U2_DscpVal='<div class="listing_detail_body w-100 fleft mb-10 not_editable">
                 <div class="listing_detail col-md-12 feature_block_Interior Details not_editable">
                 <div class="feature_chapter_name w-100 not_editable">Descriptions</div>
                 '.$U2_DscpVal.'
                 </div>
                 </div>';
    
    $U2PrkArr = explode(',', $U2Park);
    asort($U2PrkArr);
    
    $CountPrk = 1;
    $U2_PrkVal='';
    foreach($U2PrkArr as $U2_Park){
    if($U2_Park!=''){
        $U2_PrkVal.='<div class="'.$feature_block_class.' not_editable">
                     <i class="fas fa-check action-1 not_editable"></i> '.$U2_Park.'
                     </div>';
        $CountPrk++;   
    }
    }
    $U2_PrkVal='<div class="listing_detail_body w-100 fleft mb-10 not_editable">
                <div class="listing_detail col-md-12 feature_block_Interior_Details not_editable">
                <div class="feature_chapter_name w-100 not_editable">Parking</div>
                '.$U2_PrkVal.'
                </div>
                </div>';
    
    $U2Info='<div class="w-100 fleft mb-25 not_editable">
             <div class="listing_detail_body w-100 fleft mb-10 not_editable">
             <div class="listing_detail col-md-12 feature_block_Interior_Details not_editable">
             <div class="feature_chapter_name w-100 fs-15 not_editable" style="color: #FF8D1C;">Unit 2 Info</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Hotel:</strong> '.str_replace('Hotel:','',$U2_Hotel).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Efficiency:</strong> '.str_replace('Efficiency:','',$U2_Efficiency).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Bedrooms:</strong> '.str_replace('BedroomsVal:','',$U2_BedroomsVal).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Full Bath:</strong> '.str_replace('FullBathVal:','',$U2_FullBathVal).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Half Bath:</strong> '.str_replace('HalfBathVal:','',$U2_HalfBathVal).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Furnished:</strong> '.str_replace('FurnishedVal:','',$U2_FurnishedVal).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Sqm:</strong> '.str_replace('SqFtVal:','',$U2_SqFtVal).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Monthly Income:</strong> '.str_replace('MonthlyIncomeVal:','',$U2_MonthlyIncomeVal).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Lease Ends:</strong> '.str_replace('LeaseEndsVal:','',$U2_LeaseEndsVal).'</div>
             </div>
             </div>
            
             '.$U2_DscpVal.'
             '.$U2_PrkVal.'
             </div>';
    }else{
        $U2Info = '';
    }
    /** Unit 2 Info **/
    /** Unit 2 Info **/
    
    
    
    
    /** Unit 3 Info **/
    /** Unit 3 Info **/
    if($Unit3Info!=''){
    $ExpU3 = explode('#', $Unit3Info); 
    $U3_Hotel=trim($ExpU3[1]);
    $U3_Efficiency=trim($ExpU3[2]);
    $U3_Bedrooms=trim($ExpU3[3]);
    $U3_BedroomsVal=trim($ExpU3[4]);
    $U3_FullBath=trim($ExpU3[5]);
    $U3_FullBathVal=trim($ExpU3[6]);
    $U3_HalfBath=trim($ExpU3[7]);
    $U3_HalfBathVal=trim($ExpU3[8]);
    $U3_Furnished=trim($ExpU3[9]);
    $U3_FurnishedVal=trim($ExpU3[10]);
    $U3_SqFt=trim($ExpU3[11]);
    $U3_SqFtVal=trim($ExpU3[12]);
    $U3_MonthlyIncome=trim($ExpU3[13]);
    $U3_MonthlyIncomeVal=trim($ExpU3[14]);
    $U3_LeaseEnds=trim($ExpU3[15]);
    $U3_LeaseEndsVal=trim($ExpU3[16]);
    
    $U3DescArr = explode(',', $U3Desc);
    asort($U3DescArr);
    
    $CountU3Dsc = 1;
    $U3_DscpVal='';
    
    foreach($U3DescArr as $U3_Desc){
    if($U3_Desc!=''){ 
        $U3_DscpVal.='<div class="'.$feature_block_class.' not_editable">
                     <i class="fas fa-check action-1 not_editable"></i> '.$U3_Desc.'
                     </div>';
        $CountU3Dsc++;   
    }
    }
    
    $U3_DscpVal='<div class="listing_detail_body w-100 fleft mb-10 not_editable">
                 <div class="listing_detail col-md-12 feature_block_Interior Details not_editable">
                 <div class="feature_chapter_name w-100 not_editable">Descriptions</div>
                 '.$U3_DscpVal.'
                 </div>
                 </div>';
    
    $U3PrkArr = explode(',', $U3Park);
    asort($U3PrkArr);
    
    $CountPrk = 1;
    $U3_PrkVal='';
    foreach($U3PrkArr as $U3_Park){
    if($U3_Park!=''){
        $U3_PrkVal.='<div class="'.$feature_block_class.' not_editable">
                     <i class="fas fa-check action-1 not_editable"></i> '.$U3_Park.'
                     </div>';
        $CountPrk++;   
    }
    }
    $U3_PrkVal='<div class="listing_detail_body w-100 fleft mb-10 not_editable">
                <div class="listing_detail col-md-12 feature_block_Interior_Details not_editable">
                <div class="feature_chapter_name w-100 not_editable">Parking</div>
                '.$U3_PrkVal.'
                </div>
                </div>';
    
    $U3Info='<div class="w-100 fleft mb-25 not_editable">
             <div class="listing_detail_body w-100 fleft mb-10 not_editable">
             <div class="listing_detail col-md-12 feature_block_Interior_Details not_editable">
             <div class="feature_chapter_name w-100 fs-15 not_editable" style="color: #FF8D1C;">Unit 3 Info</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Hotel:</strong> '.str_replace('Hotel:','',$U3_Hotel).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Efficiency:</strong> '.str_replace('Efficiency:','',$U3_Efficiency).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Bedrooms:</strong> '.str_replace('BedroomsVal:','',$U3_BedroomsVal).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Full Bath:</strong> '.str_replace('FullBathVal:','',$U3_FullBathVal).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Half Bath:</strong> '.str_replace('HalfBathVal:','',$U3_HalfBathVal).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Furnished:</strong> '.str_replace('FurnishedVal:','',$U3_FurnishedVal).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Sqm:</strong> '.str_replace('SqFtVal:','',$U3_SqFtVal).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Monthly Income:</strong> '.str_replace('MonthlyIncomeVal:','',$U3_MonthlyIncomeVal).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Lease Ends:</strong> '.str_replace('LeaseEndsVal:','',$U3_LeaseEndsVal).'</div>
             </div>
             </div>
            
             '.$U3_DscpVal.'
             '.$U3_PrkVal.'
             </div>';
    }else{
        $U3Info = '';
    }
    /** Unit 3 Info **/
    /** Unit 3 Info **/
    
    
    
    
    /** Unit 4 Info **/
    /** Unit 4 Info **/
    if($Unit4Info!=''){
    $ExpU4 = explode('#', $Unit4Info); 
    $U4_Hotel=trim($ExpU4[1]);
    $U4_Efficiency=trim($ExpU4[2]);
    $U4_Bedrooms=trim($ExpU4[3]);
    $U4_BedroomsVal=trim($ExpU4[4]);
    $U4_FullBath=trim($ExpU4[5]);
    $U4_FullBathVal=trim($ExpU4[6]);
    $U4_HalfBath=trim($ExpU4[7]);
    $U4_HalfBathVal=trim($ExpU4[8]);
    $U4_Furnished=trim($ExpU4[9]);
    $U4_FurnishedVal=trim($ExpU4[10]);
    $U4_SqFt=trim($ExpU4[11]);
    $U4_SqFtVal=trim($ExpU4[12]);
    $U4_MonthlyIncome=trim($ExpU4[13]);
    $U4_MonthlyIncomeVal=trim($ExpU4[14]);
    $U4_LeaseEnds=trim($ExpU4[15]);
    $U4_LeaseEndsVal=trim($ExpU4[16]);
    
    $U4DescArr = explode(',', $U4Desc);
    asort($U4DescArr);
    
    $CountU4Dsc = 1;
    $U4_DscpVal='';
    
    foreach($U4DescArr as $U4_Desc){
    if($U4_Desc!=''){ 
        $U4_DscpVal.='<div class="'.$feature_block_class.' not_editable">
                     <i class="fas fa-check action-1 not_editable"></i> '.$U4_Desc.'
                     </div>';
        $CountU4Dsc++;   
    }
    }
    
    $U4_DscpVal='<div class="listing_detail_body w-100 fleft mb-10 not_editable">
                 <div class="listing_detail col-md-12 feature_block_Interior Details not_editable">
                 <div class="feature_chapter_name w-100 not_editable">Descriptions</div>
                 '.$U4_DscpVal.'
                 </div>
                 </div>';
    
    $U4PrkArr = explode(',', $U4Park);
    asort($U4PrkArr);
    
    $CountPrk = 1;
    $U4_PrkVal='';
    foreach($U4PrkArr as $U4_Park){
    if($U4_Park!=''){
        $U4_PrkVal.='<div class="'.$feature_block_class.' not_editable">
                     <i class="fas fa-check action-1 not_editable"></i> '.$U4_Park.'
                     </div>';
        $CountPrk++;   
    }
    }
    $U4_PrkVal='<div class="listing_detail_body w-100 fleft mb-10 not_editable">
                <div class="listing_detail col-md-12 feature_block_Interior_Details not_editable">
                <div class="feature_chapter_name w-100 not_editable">Parking</div>
                '.$U4_PrkVal.'
                </div>
                </div>';
    
    $U4Info='<div class="w-100 fleft mb-25 not_editable">
             <div class="listing_detail_body w-100 fleft mb-10 not_editable">
             <div class="listing_detail col-md-12 feature_block_Interior_Details not_editable">
             <div class="feature_chapter_name w-100 fs-15 not_editable" style="color: #FF8D1C;">Unit 4 Info</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Hotel:</strong> '.str_replace('Hotel:','',$U4_Hotel).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Efficiency:</strong> '.str_replace('Efficiency:','',$U4_Efficiency).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Bedrooms:</strong> '.str_replace('BedroomsVal:','',$U4_BedroomsVal).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Full Bath:</strong> '.str_replace('FullBathVal:','',$U4_FullBathVal).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Half Bath:</strong> '.str_replace('HalfBathVal:','',$U4_HalfBathVal).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Furnished:</strong> '.str_replace('FurnishedVal:','',$U4_FurnishedVal).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Sqm:</strong> '.str_replace('SqFtVal:','',$U4_SqFtVal).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Monthly Income:</strong> '.str_replace('MonthlyIncomeVal:','',$U4_MonthlyIncomeVal).'</div>
             <div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Lease Ends:</strong> '.str_replace('LeaseEndsVal:','',$U4_LeaseEndsVal).'</div>
             </div>
             </div>
            
             '.$U4_DscpVal.'
             '.$U4_PrkVal.'
             </div>';
    }else{
        $U4Info = '';
    }
    /** Unit 4 Info **/
    /** Unit 4 Info **/
    
     
    $UnitsInfo = $U1Info.$U2Info.$U3Info.$U4Info;
    
    }else{
    $UnitsInfo = '';
    }
    
    $LandLeaseInfo=array();
    $LndLsClass='col-xs-12 col-sm-6 col-md-4 col-lg-4 amItem not_editable';
    if($LandLeaseVal!=''){ array_push($LandLeaseInfo,'<div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Land Lease:</strong> '.$LandLeaseVal.'</div>'); }
    if($MinDaysToLeaseVal!=''){ array_push($LandLeaseInfo,'<div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Min Days to Lease:</strong> '.$MinDaysToLeaseVal.'</div>'); }
    if($RecreationLeaseVal!=''){ array_push($LandLeaseInfo,'<div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Recreation Lease:</strong> '.$RecreationLeaseVal.'</div>'); }
    if($LeaseTimesPerYearVal!=''){ array_push($LandLeaseInfo,'<div class="'.$feature_block_class.' not_editable"><strong class="not_editable">Lease Times Per Year:</strong> '.$LeaseTimesPerYearVal.'</div>'); }
    
    include_once 'property_details_body.php';
    
    if($PropertyType=='Residential'){
    $Rooms='<div class="listing_detail_body w-100 fleft mb-20 not_editable">
            <div class="listing_detail col-md-12 feature_block_Interior Details not_editable">
            <div class="feature_chapter_name w-100 not_editable">Living Room</div>
            <div class="'.$feature_block_class.' not_editable"><i class="fas fa-ruler-vertical action-1 not_editable"></i> <strong class="not_editable">Length: </strong>'.$LRoomLength.'</div>
            <div class="'.$feature_block_class.' not_editable"><i class="fas fa-ruler-horizontal action-1 not_editable"></i> <strong class="not_editable">Width: </strong>'.$LRoomWidth.'</div>
            <div class="'.$feature_block_class.' not_editable"><i class="fas fa-layer-group action-1 not_editable"></i> <strong class="not_editable">Level: </strong>'.$LRoomLevel.'</div>
            <div class="fleft w-100 not_editable">
            <strong class="not_editable">Remarks: </strong><span class="not_editable">'.$LRoomRemarks.'</span>
            </div>           
            </div>
            </div>
            
            <div class="listing_detail_body w-100 fleft mb-20 not_editable">
            <div class="listing_detail col-md-12 feature_block_Interior Details not_editable">
            <div class="feature_chapter_name w-100 not_editable">Kitchen</div>
            <div class="'.$feature_block_class.' not_editable"><i class="fas fa-ruler-vertical action-1 not_editable"></i> <strong class="not_editable">Length: </strong>'.$KitchenLength.'</div>
            <div class="'.$feature_block_class.' not_editable"><i class="fas fa-ruler-horizontal action-1 not_editable"></i> <strong class="not_editable">Width: </strong>'.$KitchenWidth.'</div>
            <div class="'.$feature_block_class.' not_editable"><i class="fas fa-layer-group action-1 not_editable"></i> <strong class="not_editable">Level: </strong>'.$KitchenLevel.'</div>
            <div class="fleft w-100 not_editable">
            <strong class="not_editable">Remarks: </strong><span class="not_editable">'.$KitchenRemarks.'</span>
            </div>           
            </div>
            </div>
            
            <div class="listing_detail_body w-100 fleft mb-20 not_editable">
            <div class="listing_detail col-md-12 feature_block_Interior Details not_editable">
            <div class="feature_chapter_name w-100 not_editable">Master Bedroom</div>
            <div class="'.$feature_block_class.' not_editable"><i class="fas fa-ruler-vertical action-1 not_editable"></i> <strong class="not_editable">Length: </strong>'.$MasterBedroomLength.'</div>
            <div class="'.$feature_block_class.' not_editable"><i class="fas fa-ruler-horizontal action-1 not_editable"></i> <strong class="not_editable">Width: </strong>'.$MasterBedroomWidth.'</div>
            <div class="'.$feature_block_class.' not_editable"><i class="fas fa-layer-group action-1 not_editable"></i> <strong class="not_editable">Level: </strong>'.$MasterBedroomLevel.'</div>
            <div class="fleft w-100 not_editable">
            <strong class="not_editable">Remarks: </strong><span class="not_editable">'.$MasterBedroomRemarks.'</span>
            </div>           
            </div>
            </div>';
                        
            $cstmExpld=explode('}{',$CustomeRooms); 
            foreach($cstmExpld as $cusRooms){
                $cusRooms=trim($cusRooms);
                $cusRooms=str_replace('}','',$cusRooms);
                $cusRooms=str_replace('{','',$cusRooms);
                if($cusRooms!=''){
                  $xpldRoom=explode('#,#',$cusRooms); 
                  $Rooms.='<div class="listing_detail_body w-100 fleft mb-20 not_editable">
                            <div class="listing_detail col-md-12 feature_block_Interior Details not_editable">
                            <div class="feature_chapter_name w-100 not_editable">'.$xpldRoom[0].'</div>
                            <div class="'.$feature_block_class.' not_editable"><i class="fas fa-ruler-vertical action-1 not_editable"></i> <strong class="not_editable">Length: </strong>'.$xpldRoom[1].'</div>
                            <div class="'.$feature_block_class.' not_editable"><i class="fas fa-ruler-horizontal action-1 not_editable"></i> <strong class="not_editable">Width: </strong>'.$xpldRoom[2].'</div>
                            <div class="'.$feature_block_class.' not_editable"><i class="fas fa-layer-group action-1 not_editable"></i> <strong class="not_editable">Level: </strong>'.$xpldRoom[2].'</div>
                            <div class="fleft w-100 not_editable">
                            <strong class="not_editable">Remarks: </strong><span class="not_editable">'.$xpldRoom[4].'</span>
                            </div>           
                            </div>
                           </div>';
                } 
            }
            
    }else if($PropertyType=='Rental'){ /** Load Units **/
    
    }else{
        $Rooms='';
    }
    
    $pptyArray[]=array(
    'data'=>"Done", 
    'total_records'=>$total_records,
    'MatrixUniqueNumber'=>$MatrixUniqueNumber,
    'MLSNumber'=>$MLSNumber,
    'PropertyType'=>$PropertyType,
    'PropertyTitle'=>$PropertyTitle,
    'LastUpdated'=>$LastUpdated,
    'list_price'=>number_format($list_price,0),
    'ForSale'=>$ForSale,
    'ForLease'=>$ForLease,
    'ShortLet'=>$ShortLet,
    'BathroomsFull'=>$BathroomsFull,
    'listing_company_id'=>$company_unique_id,
    'City'=>$City,
    'GarageSpaces'=>$GarageSpaces,
    'PicturesMain'=>$PicturesMain,
    'PicturesHigh'=>$PicturesHigh,
    'PicturesMedium'=>$PicturesMedium,
    'PicturesTotal'=>$PicturesTotal,
    'LotSqFt'=>$LotSqFt,
    'MapAddress'=>$MapAddress,
    'Status'=>$Status,
    'State'=>$State,
    'StreetName'=>$StreetName,
    'StreetNumber'=>$StreetNumber,
    'PostalCode'=>$PostalCode,
    'SubLocality'=>$SubLocality,
    'Longitude'=>$Longitude,
    'Latitude'=>$Latitude,
    'Address'=>$address,
    'propertyLink'=>$propertyLink,
    'SqFtTotal'=>$SqFtTotal,
    'TotalBedrooms'=>$TotalBedrooms,
    'PublicRemarks'=>$PublicRemarks,
    'GeneralDescription'=>$GeneralDescription,
    'NursPriSchool'=>$NursPriSchool,
    'SecondarySchool'=>$SecondarySchool,
    'Landmark'=>$Landmark,
    'UnitsInfo'=>$UnitsInfo,
    'CustomRooms'=>$CustomeRooms,
    'TotalOrganicViews_Own'=>$TotalOrganicViews_Own,
    'TotalPaidViews_Own'=>$TotalPaidViews_Own,
    'TotalOrganicViews_Others'=>$TotalOrganicViews_Others,
    'TotalPaidViews_Others'=>$TotalPaidViews_Others,
    'youtube_video_link'=>$youtube_video_link,
    'virtual_tour_link'=>$virtual_tour_link,
    'Rooms'=>$Rooms,
    'YearBuilt'=>$YearBuilt,
    'LandLeaseInfo'=>$LandLeaseInfo,
    'PropertyDetails'=>$PropertyDetails /** inside property_details_body.php **/
    );
    
    $RelatedCity=$City;
    $RelatedState=$State;
    /** properties **/
    /** properties **/ 
      
    }else{
    $pptyArray[]=array('data'=>'Property not found.');
    }
    
    /** related properties **/
    /** related properties **/
    $to_sel="MatrixUniqueNumber, MLSNumber, PropertyType, PropertyTitle, list_price, ForSale, ForLease, ShortLet, BathroomsFull, City, company_unique_id, GarageSpaces, LotSqFt, MapAddress, PicturesMain, State, StreetName, StreetNumber, SubLocality, SqFtTotal, TotalBedrooms";
    $sqlReltdPPTY="SELECT $to_sel FROM listings WHERE City='$RelatedCity'  AND Status='Active' ORDER BY rand() LIMIT $related_limits";
    $reltdRslt=mysqli_query($conn,$sqlReltdPPTY) or die(mysqli_error($conn));
    $reltdPptyExist=mysqli_num_rows($reltdRslt); 
    
    if($reltdPptyExist<1){ /** Not found use other query **/
    $sqlReltdPPTY="SELECT $to_sel FROM listings WHERE State='$RelatedState'  AND Status='Active' ORDER BY rand() LIMIT $related_limits";
    $reltdRslt=mysqli_query($conn,$sqlReltdPPTY) or die(mysqli_error($conn));
    $reltdPptyExist=mysqli_num_rows($reltdRslt);
    
    if($reltdPptyExist<1){ /** Not found, select any **/
    $sqlReltdPPTY="SELECT $to_sel FROM listings WHERE Status='Active' ORDER BY rand() LIMIT $related_limits";
    $reltdRslt=mysqli_query($conn,$sqlReltdPPTY) or die(mysqli_error($conn));
    $reltdPptyExist=mysqli_num_rows($reltdRslt);    
    }  
    }
    
    if($reltdPptyExist>0){
    
    while($Rrow=mysqli_fetch_array($reltdRslt)){ 
    $R_MatrixUniqueNumber=$Rrow['MatrixUniqueNumber'];
    $R_MLSNumber=$Rrow['MLSNumber'];
    $R_PropertyType=$Rrow['PropertyType'];
    $R_PropertyTitle=$Rrow['PropertyTitle'];
    $R_list_price=$Rrow['list_price'];
    $R_ForSale=$Rrow['ForSale'];
    $R_ForLease=$Rrow['ForLease'];
    $R_ShortLet=$Rrow['ShortLet'];
    $R_BathroomsFull=$Rrow['BathroomsFull'];
    $R_listing_company_id=$Rrow['company_unique_id'];
    $R_City=$Rrow['City'];
    $R_GarageSpaces=$Rrow['GarageSpaces'];
    $R_MapAddress=$Rrow['MapAddress'];
    $R_PicturesMain=$Rrow['PicturesMain'];
    $R_State=$Rrow['State'];
    $R_StreetName=$Rrow['StreetName'];
    $R_StreetNumber=$Rrow['StreetNumber'];
    $R_SubLocality=$Rrow['SubLocality'];
    $R_SqFtTotal=$Rrow['SqFtTotal'];
    $R_TotalBedrooms=$Rrow['TotalBedrooms'];
    
    $R_address=$R_StreetNumber.' '.$R_StreetName.' '.$R_SubLocality.', '.$R_City.', '.$R_State;
    
    $st_num=preg_replace("/[^0-9]/","",$R_StreetNumber);
    $st_nam=preg_replace("/[^A-Za-z]/","",$R_StreetName);
    $st_sub=preg_replace("/[^A-Za-z]/","",$R_SubLocality);
    $cty=preg_replace("/[^A-Za-z]/","",$R_City);
    $state=preg_replace("/[^A-Za-z]/","",$R_State);
                                          
    if($st_num!=''){                    
        $st_num=$st_num.'-';          
    }                                     
                                          
    if($st_nam!=''){                    
        $st_nam=$st_nam.'-';          
    }                                     
                                          
    if($st_sub!=''){      
        $st_sub=$st_sub.'-';          
    }                                    
                                          
    if($cty!=''){      
        $cty=$cty.'-';          
    }                                     
                                          
    $R_propertyLink=$st_num.$st_nam.$st_sub.$cty.$state;
    $R_propertyLink=strtolower($R_propertyLink);
    
    $reltdArray[]=array(
    'data'=>"Done",
    'MatrixUniqueNumber'=>$R_MatrixUniqueNumber,
    'MLSNumber'=>$R_MLSNumber,
    'PropertyType'=>$R_PropertyType,
    'PropertyTitle'=>$R_PropertyTitle,
    'list_price'=>number_format($R_list_price,0),
    'ForSale'=>$R_ForSale,
    'ForLease'=>$R_ForLease,
    'ShortLet'=>$R_ShortLet,
    'BathroomsFull'=>$R_BathroomsFull,
    'listing_company_id'=>$R_listing_company_id,
    'City'=>$R_City,
    'GarageSpaces'=>$R_GarageSpaces,
    'PicturesMain'=>$R_PicturesMain,
    'MapAddress'=>$R_MapAddress,
    'State'=>$R_State,
    'StreetName'=>$R_StreetName,
    'StreetNumber'=>$R_StreetNumber,
    'SubLocality'=>$R_SubLocality,
    'Address'=>$R_address,
    'propertyLink'=>$R_propertyLink,
    'SqFtTotal'=>$R_SqFtTotal,
    'TotalBedrooms'=>$R_TotalBedrooms
    );
    }
      
    }else{
    $reltdArray[]=array('data'=>'No related property found in '.$RelatedCity);
    }
    /** related properties **/
    /** related properties **/ 
    
    
    /** closed sales **/
    /** closed sales **/
    $sales_sel="closing_price, closing_date, UnitAptNumber, salesType, Beds, Baths, LivingAreaSqFt, TotalUnitSoldRented";
    $sqlClosedSales="SELECT $sales_sel FROM closed_sales WHERE MLSNumber='$mls_number' AND status='Validated' ORDER BY closing_date DESC";
    $salesRslt=mysqli_query($conn,$sqlClosedSales) or die(mysqli_error($conn));
    $soldPptyExist=mysqli_num_rows($salesRslt);
    
    if($soldPptyExist>0){
        while($rowSld = mysqli_fetch_array($salesRslt)){
        extract($rowSld);
        $clsdSalesArray[]=array('data'=>'Done', 'sold_ppty_exist'=>$soldPptyExist, 'closing_price'=>$closing_price, 'closing_date'=>$closing_date, 'UnitAptNumber'=>$UnitAptNumber, 'salesType'=>$salesType, 'Beds'=>$Beds, 'Baths'=>$Baths, 'LivingAreaSqFt'=>$LivingAreaSqFt, 'TotalUnitSoldRented'=>$TotalUnitSoldRented);
        }
    }else{
        $clsdSalesArray[]=array('data'=>'No sales history found.');
    } 
    
    $restlArray=array(
    'data'=>'Done',
    'ads'=>'',
    'properties'=>$pptyArray,
    'related'=>$reltdArray,
    'closed_sales'=>$clsdSalesArray
    );
    
    echo json_encode($restlArray);   
    
    
    }else if($type=='Favourites'){
    
    if($browser == 'Live'){
    $favoritesID=json_decode($_POST['favoritesID']);
    }else{
    $favoritesID = array('NR840A1NH1ZFP1h','NRTWNa2xMVDxyVK','NRS34628W604g84','NR072H931gTFa04','NRF28NN4sTtyW90','NRZ702D0W8s08NX','NRYP343809tV6QV','NRHA8193HFT287T');
    }
    
    $limit=$_POST['limit']; 
    
    if(isset($_POST["page"])){
    $page=$_POST["page"];
    }else{
    $page=1;
    }
     
    $NumToSel=$page*$limit; 
    $favX='';
    $startFrom = ($page-1) * $limit; 
    
    $total_records = count($favoritesID);
    $favsArray=array_slice($favoritesID, $startFrom, $limit);
     
    foreach($favsArray as $favID){
       if($favID!=''){
        
        $to_sel="MatrixUniqueNumber, MLSNumber, PropertyType, PropertyTitle, list_price, ForSale, ForLease, ShortLet, BathroomsFull, City, company_unique_id, GarageSpaces, LotSqFt, MapAddress, PicturesMain, Status, State, StreetName, StreetNumber, SubLocality, SqFtTotal, TotalBedrooms";
        $sqlPPTY="SELECT $to_sel FROM listings WHERE MLSNumber='$favID'";
        $pptyRslt=mysqli_query($conn,$sqlPPTY) or die(mysqli_error($conn));
        $pptyExist=mysqli_num_rows($pptyRslt); 
        if($pptyExist>0){
        
        while($row=mysqli_fetch_array($pptyRslt)){ 
        extract($row);
        
        $address=$StreetNumber.' '.$StreetName.' '.$SubLocality.', '.$City.', '.$State;
        
        $l_st_num=preg_replace("/[^0-9]/","",$StreetNumber);
        $l_st_nam=preg_replace("/[^A-Za-z]/","",$StreetName);
        $l_st_sub=preg_replace("/[^A-Za-z]/","",$SubLocality);
        $l_cty=preg_replace("/[^A-Za-z]/","",$City);
        $l_state=preg_replace("/[^A-Za-z]/","",$State);
                                              
        if($l_st_num!=''){                    
            $l_st_num=$l_st_num.'-';          
        }                                     
                                              
        if($l_st_nam!=''){                    
            $l_st_nam=$l_st_nam.'-';          
        }                                     
                                              
        if($l_st_sub!=''){      
            $l_st_sub=$l_st_sub.'-';          
        }                                    
                                              
        if($l_cty!=''){      
            $l_cty=$l_cty.'-';          
        }                                     
                                              
        $propertyLink=$l_st_num.$l_st_nam.$l_st_sub.$l_cty.$l_state;
        $propertyLink=strtolower($propertyLink);
        
        $pptyArray[]=array(
        'data'=>"Done", 
        'total_records'=>$total_records,
        'MatrixUniqueNumber'=>$MatrixUniqueNumber,
        'MLSNumber'=>$MLSNumber,
        'PropertyType'=>$PropertyType,
        'PropertyTitle'=>$PropertyTitle,
        'list_price'=>number_format($list_price,0),
        'ForSale'=>$ForSale,
        'ForLease'=>$ForLease,
        'ShortLet'=>$ShortLet,
        'BathroomsFull'=>$BathroomsFull,
        'listing_company_id'=>$company_unique_id,
        'City'=>$City,
        'GarageSpaces'=>$GarageSpaces,
        'PicturesMain'=>$PicturesMain,
        'LotSqFt'=>$LotSqFt,
        'MapAddress'=>$MapAddress,
        'Status'=>$Status,
        'State'=>$State,
        'StreetName'=>$StreetName,
        'StreetNumber'=>$StreetNumber,
        'SubLocality'=>$SubLocality,
        'Address'=>$address,
        'propertyLink'=>$propertyLink,
        'ResultHeader'=>$resultHdr,
        'SqFtTotal'=>$SqFtTotal,
        'TotalBedrooms'=>$TotalBedrooms
        );
        } 
                
       }else{
        $pptyArray[]=array('data'=>'No favourites to display on this page');
       }
       }     
       /** properties **/
       /** properties **/ 
    }
    
    $restlArray=array(
    'data'=>'Done',
    'properties'=>$pptyArray
    );
    
    echo json_encode($restlArray);
      
    }else if($type=='Our Listings'){
        
    $limit=$_POST['limit'];
    $compUniqueID=$_POST['company_unique_id'];
    $parent_company_accnt_id=$_POST['parent_company_accnt_id'];
    $sort_by=$_POST["sort"];
    
    if(isset($_POST["page"])){
    $page=$_POST["page"];
    }else{
    $page=1;
    }
    
    if($sort_by=="sqft-asc"){
     $order_by="CAST(SqFtTotal as DECIMAL(10,5)) ASC";   
    }else if($sort_by=="sqft-desc"){
     $order_by="CAST(SqFtTotal as DECIMAL(10,5)) DESC";   
    }else if($sort_by=="lot-asc"){
     $order_by="CAST(LotSqFt as DECIMAL(10,5)) ASC";   
    }else if($sort_by=="lot-desc"){
     $order_by="CAST(LotSqFt as DECIMAL(10,5)) DESC";   
    }else if($sort_by=="baths-asc"){
     $order_by="CAST(BathroomsFull as DECIMAL) ASC";    
    }else if($sort_by=="baths-desc"){
     $order_by="CAST(BathroomsFull as DECIMAL) DESC";    
    }else if($sort_by=="beds-asc"){
     $order_by="CAST(TotalBedrooms as DECIMAL) ASC";    
    }else if($sort_by=="beds-desc"){
     $order_by="CAST(TotalBedrooms as DECIMAL) DESC";    
    }else if($sort_by=="garages-asc"){
     $order_by="CAST(GarageSpaces as DECIMAL) ASC";    
    }else if($sort_by=="garages-desc"){
     $order_by="CAST(GarageSpaces as DECIMAL) DESC";    
    }else if($sort_by=="price-asc"){
     $order_by="CAST(list_price as DECIMAL) ASC";   
    }else if($sort_by=="price-desc"){
     $order_by="CAST(list_price as DECIMAL) DESC";   
    }else{ /** not set **/
     $order_by="CAST(list_price as DECIMAL) ASC";   
    }
    
    $start_from = ($page-1) * $limit;
    
    /** properties **/
    /** properties **/
    
    if($parent_company_accnt_id!=''){
      $fld = " OR company_unique_id='$parent_company_accnt_id'";
    }else{
      $fld = "";  
    }
    
    if($browser == 'Live'){
        $listngsTbl = 'listings';
    }else{
        $listngsTbl = 'z_dummy_listings';
    }
        
    $sqlTotal="SELECT MLSNumber FROM $listngsTbl WHERE (company_unique_id='$compUniqueID' $fld) AND Status='Active' ";
    $ttlRslt=mysqli_query($conn,$sqlTotal) or die(mysqli_error($conn));
    $total_records=mysqli_num_rows($ttlRslt);
     
    $to_sel="MatrixUniqueNumber, MLSNumber, PropertyType, PropertyTitle, list_price, ForSale, ForLease, ShortLet, BathroomsFull, City, company_unique_id, GarageSpaces, LotSqFt, MapAddress, PicturesMain, State, StreetName, StreetNumber, SubLocality, SqFtTotal, TotalBedrooms";
    $sqlPPTY="SELECT $to_sel FROM $listngsTbl WHERE (company_unique_id='$compUniqueID' $fld) AND Status='Active' ORDER BY $order_by LIMIT $start_from, $limit";
    $pptyRslt=mysqli_query($conn,$sqlPPTY) or die(mysqli_error($conn));
    $pptyExist=mysqli_num_rows($pptyRslt); 
    if($pptyExist>0){
    
    while($row=mysqli_fetch_array($pptyRslt)){ 
    extract($row);
    
    $address=$StreetNumber.' '.$StreetName.' '.$SubLocality.', '.$City.', '.$State;
    
    $l_st_num=preg_replace("/[^0-9]/","",$StreetNumber);
    $l_st_nam=preg_replace("/[^A-Za-z]/","",$StreetName);
    $l_st_sub=preg_replace("/[^A-Za-z]/","",$SubLocality);
    $l_cty=preg_replace("/[^A-Za-z]/","",$City);
    $l_state=preg_replace("/[^A-Za-z]/","",$State);
                                          
    if($l_st_num!=''){                    
        $l_st_num=$l_st_num.'-';          
    }                                     
                                          
    if($l_st_nam!=''){                    
        $l_st_nam=$l_st_nam.'-';          
    }                                     
                                          
    if($l_st_sub!=''){      
        $l_st_sub=$l_st_sub.'-';          
    }                                    
                                          
    if($l_cty!=''){      
        $l_cty=$l_cty.'-';          
    }                                     
                                          
    $propertyLink=$l_st_num.$l_st_nam.$l_st_sub.$l_cty.$l_state;
    $propertyLink=strtolower($propertyLink);
    
    $pptyArray[]=array(
    'data'=>"Done", 
    'total_records'=>$total_records,
    'MatrixUniqueNumber'=>$MatrixUniqueNumber,
    'MLSNumber'=>$MLSNumber,
    'PropertyType'=>$PropertyType,
    'PropertyTitle'=>$PropertyTitle,
    'list_price'=>number_format($list_price,0),
    'ForSale'=>$ForSale,
    'ForLease'=>$ForLease,
    'ShortLet'=>$ShortLet,
    'BathroomsFull'=>$BathroomsFull,
    'listing_company_id'=>$company_unique_id,
    'City'=>$City,
    'GarageSpaces'=>$GarageSpaces,
    'PicturesMain'=>$PicturesMain,
    'LotSqFt'=>$LotSqFt,
    'MapAddress'=>$MapAddress,
    'State'=>$State,
    'StreetName'=>$StreetName,
    'StreetNumber'=>$StreetNumber,
    'SubLocality'=>$SubLocality,
    'Address'=>$address,
    'propertyLink'=>$propertyLink,
    'ResultHeader'=>$resultHdr,
    'SqFtTotal'=>$SqFtTotal,
    'TotalBedrooms'=>$TotalBedrooms
    );
    
    }
    /** properties **/
    /** properties **/ 
      
    }else{
    $pptyArray[]=array('data'=>'No listings to display on this page');
    } 
    
    $restlArray=array(
    'data'=>'Done',
    'total_items'=>$pptyExist,
    'ads'=>'',
    'properties'=>$pptyArray,
    'related'=>''
    );
    
    echo json_encode($restlArray);
    
    }

}else{
    $restlArray[]=array('data'=>'Error receiving all required data'); 
    echo json_encode($restlArray); 
}
?>