<?php
header('Access-Control-Allow-Origin: *');
header('Content-type: application/json');

include 'connect.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
//error_reporting(0);

require_once 'vendor/autoload.php';  
ini_set('max_execution_time', 60); //60 seconds = 1 min 

function sendMail($conn,$company_unique_id,$property_type,$beds,$baths,$max_price,$state,$neighbourhood,$i_am,$fullname,$countryCode,$phone,$mail_from,$msgBody){
    
    $checkCompany = "SELECT name, contact_email, contact_phone, office_address_1, office_address_2, logo, website_url FROM company WHERE company_unique_id='$company_unique_id'";
    $companyRslt = mysqli_query($conn,$checkCompany) or die(mysqli_error($conn));
    
    $rowComp=mysqli_fetch_array($companyRslt);
    extract($rowComp);
    
    $subject = "New Property Request"; 
    $emailBody ='<table cellspacing="0" cellpadding="0" border="0" bgcolor="white" style="color:#5e6670;font-family:Helvetica,Arial,sans-serif;font-size:15px;line-height:1.25em;background-color:white;padding:0;text-align:left;padding-bottom:20px">
    <tbody>
     
    
    <tr>
    <td width="92%">  
    <table align="center" width="600" style="color:#5e6670;font-family:Helvetica,Arial,sans-serif;font-size:15px;line-height:1.25em;background-color:white;padding:0;text-align:left;padding-bottom:20px">
    <tbody> 
    <tr>
    <td>  
    
    <p style="line-height: 1.5em;"> 
    <b>Property Type: </b>'.$property_type.'<br/> 
    <b>Beds: </b>'.$beds.'<br/> 
    <b>Baths: </b>'.$baths.'<br/>
    <b>Maximum Price: </b>&#8358;'.number_format($max_price,0).'<br/> 
    <b>State: </b>'.$state.'<br/> 
    <b>Neighbourhood: </b>'.$neighbourhood.'<br/> 
    <b>I am an: </b>'.$i_am.'<br/> 
    <b>Full Name: </b>'.$fullname.'<br/> 
    <b>Phone: </b>+'.$countryCode.$phone.'<br/> 
    <b>Email: </b>'.$mail_from.'<br/> 
    <b>Additional Information: </b>'.$msgBody.'<br/> 
    </div>
    </p>
     
    <br>
    <br> 
    <br />
    <br /> 
    </td>
    </tr>
        
    </tbody>
    </table>
     
    </td>
    </tr>
    </tbody>';     
    
    $checkKey = "SELECT sendgridKey FROM system_settings WHERE settings_id!=''";
    $keyRslt = mysqli_query($conn,$checkKey) or die(mysqli_error($conn));
    $rowC=mysqli_fetch_array($keyRslt);
    $sendgridKey = $rowC['sendgridKey'];
    
    $email = new \SendGrid\Mail\Mail(); 
    $email->setFrom($mail_from, $fullname);
    $email->setSubject($subject);
    $email->addTo($contact_email, $name);
    $email->addContent("text/plain", 'You need to view this email in an HTML enabled browser.');
    $email->addContent("text/html", $emailBody);  
    $sendgrid = new \SendGrid($sendgridKey);
 
    try {  
    $response = $sendgrid->send($email);
    $code = $response->statusCode();
    
    if($code=='202'){ /** mail sent **/ 
    $restlArray=array('data'=>'Done'); 
    }else{ 
    $error=$response->body(); 
    $errors=json_decode($error);   
    $message=$errors->errors[0]->message;
    $restlArray=array('data'=>"Error sending email: ".$message);      
    }    
    
    }catch (\Exception $e) {  
    $message = $e->getMessage(); 
    $restlArray=array('data'=>"Error sending email: ".$message);   
    }
    
    echo json_encode($restlArray); 
}


if(isset($_POST['email']) && isset($_POST['property_type']) && isset($_POST['beds']) && isset($_POST['state'])){
    
    $company_unique_id = $_POST['company_unique_id'];
    $property_type=filterThis($_POST['property_type']); 
    $beds=filterThis($_POST['beds']); 
    $baths=filterThis($_POST['baths']);  
    $max_price=filterThis($_POST['max_price']); 
    $state=filterThis($_POST['state']);  
    $neighbourhood=filterThis($_POST['neighbourhood']);  
    $i_am=filterThis($_POST['i_am']);  
    $fullname=filterThis($_POST['fullname']); 
    $country=filterThis($_POST['country']); 
    $phone=filterThis($_POST['phone']); 
    $email=filterThis(strtolower($_POST['email'])); 
    $additional_info=filterThis($_POST['additional_info']); 
    $msgBody=nl2br($_POST['additional_info']);
    
    $date=date("Y-m-d g:i:s");
    $addUp="INSERT INTO messages(company_unique_id, fullname, email, phone, message, type, property_type, beds, baths, max_price, state, neighbourhood, i_am, country, date) 
    VALUES('$company_unique_id', '$fullname', '$email', '$phone', '$additional_info', 'Request', '$property_type', '$beds', '$baths', '$max_price', '$state', '$neighbourhood', '$i_am', '$country', '$date')";
    $qryRslt=mysqli_query($conn,$addUp) or die(mysqli_error($conn));
    
    sendMail($conn,$company_unique_id,$property_type,$beds,$baths,$max_price,$state,$neighbourhood,$i_am,$fullname,$country,$phone,$email,$msgBody);  
}
?>