<?php
session_start();
header('Access-Control-Allow-Origin: *');
header('Content-type: application/json');
include 'connect.php';

require_once 'vendor/autoload.php'; 
ini_set('max_execution_time', 120); //120 seconds = 2 minutes
 

if(isset($_POST['user_email']) && isset($_POST['subject']) && isset($_POST['eml_body'])){ 
    
    $fullname=$_POST['fullname'];
    $user_email=strtolower($_POST['user_email']);
    $subject=$_POST['subject'];
    $eml_body=$_POST['eml_body'];
    $support_email=$_POST['support_email'];
    $company_name=strtolower($_POST['company_name']);
    $sendgridKey=$_POST['sendgridKey'];
    
    $mail = new \SendGrid\Mail\Mail(); 
    $mail->setFrom($support_email, $company_name);
    $mail->setSubject($subject);
    $mail->addTo($user_email, $fullname); 
    $mail->addContent("text/plain", 'You need to view this email in an HTML enabled browser.');
    $mail->addContent("text/html", $eml_body); 
    $sendgrid = new \SendGrid($sendgridKey);
    $date=date('Y-m-d H:i:s');  
    
    try {  
    $response = $sendgrid->send($mail);
    $code = $response->statusCode();
    
    if($code=='202'){ /** mail sent **/        
    $restlArray=array('data'=>'Done'); 
    }else{
    /** insert into system reports notification **/ 
    /** keep emails in queue until problem is rectified **/ 
    $error=$response->body(); 
    $errors=json_decode($error);   
    $message=$errors->errors[0]->message; 
    $restlArray=array('data'=>$message);  
    }
    
    }catch (\Exception $e) { 
     /** insert into system reports notification **/ 
     /** keep emails in queue until problem is rectified **/  
     $message = $e->getMessage();
     $restlArray=array('data'=>$message);
    } 
    
    echo json_encode($restlArray);
}
?>