<?php
include 'REST/connect.php';
require_once 'REST/vendor/autoload.php'; 
ini_set('max_execution_time', 120); //120 seconds = 2 min 

function sendMail($conn,$email,$agent_id,$company_unique_id,$firstname,$referenceID,$transactionID,$status,$selected_domain,$total_price,$mls_subscription_plan,$hosting_plan,$billing_cycle,$domain_fee,$mls_subscription_price,$hosting_fee_val,$sendgridKey){

    $selEmailBody="SELECT html_contents, subject FROM admin_emails_templates WHERE name='Setup Payment Received'";
    $emlRslt=mysqli_query($conn,$selEmailBody) or die(mysqli_error($conn));
    $rowEml=mysqli_fetch_array($emlRslt); 
    $subject=$rowEml['subject'];
    $emailBody=$rowEml['html_contents'];
    
    $emailBody=str_replace('[firstname]',$firstname,$emailBody);
    $emailBody=str_replace('[transaction_id]',$transactionID,$emailBody);
    $emailBody=str_replace('[refrence_id]',$referenceID,$emailBody);
    $emailBody=str_replace('[transaction_status]',$status,$emailBody);
    $emailBody=str_replace('[domain_name]',$selected_domain,$emailBody);
    $emailBody=str_replace('[domain_fee]',number_format($domain_fee,2),$emailBody);
    $emailBody=str_replace('[hosting_plan]',$hosting_plan,$emailBody);
    $emailBody=str_replace('[hosting_fee]',number_format($hosting_fee_val,2),$emailBody);
    $emailBody=str_replace('[mls_subscription_plan]',$mls_subscription_plan,$emailBody);
    $emailBody=str_replace('[mls_subscription_fee]',number_format($mls_subscription_price,2),$emailBody);
    $emailBody=str_replace('[mls_billing_cycle]',$billing_cycle,$emailBody);
    $emailBody=str_replace('[total_price]',number_format($total_price,2),$emailBody);
    
    $mail = new \SendGrid\Mail\Mail(); 
    $mail->setFrom('support@ngrealtymls.com', 'Ng Realty MLS');
    $mail->setSubject($subject);
    $mail->addTo($email, $firstname); 
    $mail->addContent("text/plain", 'You need to view this email in an HTML enabled browser.');
    $mail->addContent("text/html", $emailBody);  
    $sendgrid = new \SendGrid($sendgridKey);
 
    try {  
    $response = $sendgrid->send($mail);
    $code = $response->statusCode();
    
    if($code=='202'){ /** mail sent **/       
    $restlArray=array('data'=>'Done'); 
    }else{
    /** insert into system reports notification **/ 
    /** keep emails in queue until problem is rectified **/ 
    $error=$response->body(); 
    $errors=json_decode($error);   
    $message=$errors->errors[0]->message;
    //$restlArray=array('data'=>"Error sending email: ".$message);     
    $restlArray=array('data'=>'Done'); /** success anyway no account verification **/  
    }    
    
    }catch (\Exception $e) { 
    /** insert into system reports notification **/ 
    /** keep emails in queue until problem is rectified **/  
    $message = $e->getMessage(); 
    //$restlArray=array('data'=>"Error sending email: ".$message);  
    $restlArray=array('data'=>'Done'); /** success anyway no account verification **/  
    } 
    
    echo json_encode($restlArray);
}


if(isset($_POST['theme_id']) && isset($_POST['theme_settings']) && isset($_POST['email']) && isset($_POST['agent_id']) && isset($_POST['company_unique_id']) && isset($_POST['referenceID']) && isset($_POST['transactionID']) && isset($_POST['status']) && isset($_POST['message'])){
    
    $theme_id=$_POST['theme_id'];
    $theme_settings=$_POST['theme_settings'];
    $theme_name=$_POST['theme_name'];
    $theme_link=$_POST['theme_link'];
    $email=$_POST['email'];
    $agent_id=$_POST['agent_id'];
    $firstname=$_POST['firstname'];
    $company_unique_id=$_POST['company_unique_id'];
    $referenceID=$_POST['referenceID'];
    $transactionID=$_POST['transactionID'];
    $status=$_POST['status']; 
    $message=$_POST['message'];
    $domain_extensions=$_POST['domain_extensions'];
    $selected_domain=$_POST['selected_domain']; 
    $total_price=$_POST['total_price'];  
    $mls_subscription_plan=$_POST['mls_subscription_plan'];
    $hosting_plan=$_POST['hosting_plan'];
    $billing_cycle=$_POST['billing_cycle'];
    $domain_fee=$_POST['domain_fee'];
    $mls_subscription_price=$_POST['mls_subscription_price'];
    $hosting_fee_val=$_POST['hosting_fee_val'];
    
    $date=date('Y-m-d H:i:s'); //Now
    
    $planStarts=date('Y-m-d H:i:s'); //Now
    if($billing_cycle=='Monthly'){
        $planEnds=date('Y-m-d H:i:s', strtotime("+30 days")); // will be 30 days 
    }else if($billing_cycle=='Quarterly'){
        $planEnds=date('Y-m-d H:i:s', strtotime("+3 months")); // will be 3 months 
    }else if($billing_cycle=='SemiAnnually'){
        $billing_cycle = 'Semi-Annually'; /** now becomes **/
        $planEnds=date('Y-m-d H:i:s', strtotime("+6 months")); // will be 6 months 
    }else if($billing_cycle=='Annually'){
        $planEnds=date('Y-m-d H:i:s', strtotime("+1 years")); // will be 1 year 
    }else if($billing_cycle=='Biennially'){
        $planEnds=date('Y-m-d H:i:s', strtotime("+2 years")); // will be 2 years 
    }else if($billing_cycle=='Triennially'){
        $planEnds=date('Y-m-d H:i:s', strtotime("+3 years")); // will be 3 years 
    }
 
$summary = 'Domain: '.$selected_domain.'\n
Domain Extension: '.$domain_extensions.'\n
Domain Fee: &#8358;'.number_format($domain_fee,2).'\n
Theme: <a href="'.$theme_link.'" target="_blank">'.$theme_name.'</a>\n
Theme ID: '.$theme_id.'\n
MLS Subscription Plan: '.$mls_subscription_plan.'\n
MLS Subscription Plan Fee: &#8358;'.number_format($mls_subscription_price,2).'\n
Hosting Plan: '.$hosting_plan.'\n
Hosting Plan Fee: &#8358;'.number_format($hosting_fee_val,2).'\n
Billing Cycle: '.$billing_cycle;
    
    
    $checkTrans="SELECT payment_id FROM payments WHERE company_unique_id='$company_unique_id' AND transaction_id='$transactionID' AND refrence_id='$referenceID'"; 
    $transRslt=mysqli_query($conn,$checkTrans);
    $transExist = mysqli_num_rows($transRslt);  
     
    if($transExist<1){
        $addTrans="INSERT INTO payments(company_unique_id, agent_id, email, type, transaction_id, refrence_id, status, message, amount, summary, date) 
        VALUES('$company_unique_id', '$agent_id', '$email', 'Setup', '$transactionID', '$referenceID', '$status', '$message', '$total_price', '$summary', '$date')";
        $addTransRslt=mysqli_query($conn,$addTrans);
        
        $addRequest="INSERT INTO setup_request(company_unique_id, agent_id, theme_id, request_body, date) VALUES('$company_unique_id', '$agent_id', '$theme_id', '$summary', '$date')";
        $addRequestRslt=mysqli_query($conn,$addRequest);
        
        $custom_theme_settings = '{"PrimaryThemeColor":"rgb(70, 109, 240)","PrimaryTextColor":"rgb(255, 255, 255)","SecondaryThemeColor":"rgb(247, 45, 149)","SecondaryTextColor":"rgb(252, 255, 255)","ServiceTitle":"Top Services","ServiceSubTitle":"This is some of our top services","NumOfSrvc":"4","ShowOurServices":"Yes","PropertyImgRes":"Medium","PropListStyle":"List","SortBy":"beds-asc","MaxPropertyList":"21","OurListingsTitle":"Our Latest Listings","OurListingsSubTitle":"This is some of recent properties 2019","ShowOurListings":"Yes","NumOfOurProp":"3","FeaturedListingsTitle":"Featured Listings","FeaturedListingsSubTitle":"Check out these properties you might be interested in","NumOfFeatrdProp":"3","ShowFeaturedListings":"Yes","PopularPlacesTitle":"Most Popular Places","PopularPlacesSubTitle":"Find Nice Properties In Top Cities","ShowPopularPlaces":"Yes","OurAgentsTitle":"Our Top Agents","OurAgentsSubTitle":"Our team of agents are ready to help you reach your real estate goals","ShowOurAgents":"Yes","TestimonialsTitle":"Testimonials","TestimonialsSubTitle":"Check out what our clients says about us","NumOfTestimonials":"5","ShowTestimonials":"Yes","BlogTitle":"Recent Stories From Our Blog","NumOfBlogPosts":"3","ShowBlogPosts":"Yes","FooterBgColor":"rgb(51,51,51)","FooterPrimaryTextColor":"rgb(255, 255, 255)","FooterSecondaryTextColor":"rgb(153, 153, 153)","LiveChatOnlineColor":"rgb(130, 224, 29)","LiveChatOfflineColor":"rgb(245, 0, 0)"}';
        //$custom_section = 'TopSection:{{Find your new place with Real Finder}},TopSection:{{Fusce risus metus, placerat in consectetur eu, porttitor a est sed sed dolor lorem cras adipiscing}},TopSection:{{Yes}},MidSection:{{Find Properties That Make You Money}},MidSection:{{Lorem ipsum dolor sit amet, consectetur adipisicing elit. Eligendi quia fugiat ea adipisci earum repudiandae, corporis culpa esse distinctio consequuntur?}},MidSection:{{}},MidSection:{{Yes}},BottomSection:{{Best Place For  Sell Properties}},BottomSection:{{Looking To Sell Or Rent Your Property?}},BottomSection:{{Call us now: 080xxxxxxxx, 070xxxxxxxx}},BottomSection:{{Yes}}';
        
        $upCompany="UPDATE company SET subscription_type='$mls_subscription_plan', subscription_starts='$planStarts', subscription_ends='$planEnds', subscription_status='Active', billing_cycle='$billing_cycle', theme='$theme_id', theme_setup_status='Setting Up', theme_settings='$theme_settings', custom_theme_settings='$custom_theme_settings' WHERE company_unique_id='$company_unique_id'"; //, custom_section='$custom_section'
        $upRslt=mysqli_query($conn,$upCompany);
        
        if($addTransRslt && $addRequestRslt && $upRslt){
            
        $selSettings="SELECT sendgridKey FROM system_settings WHERE settings_id!='' order by settings_id ASC LIMIT 1";
        $settRslt=mysqli_query($conn,$selSettings) or die(mysqli_error($conn));
        $rowSet=mysqli_fetch_array($settRslt); 
        $sendgridKey=$rowSet['sendgridKey'];
    
        sendMail($conn,$email,$agent_id,$company_unique_id,$firstname,$referenceID,$transactionID,$status,$selected_domain,$total_price,$mls_subscription_plan,$hosting_plan,$billing_cycle,$domain_fee,$mls_subscription_price,$hosting_fee_val,$sendgridKey);
    
        }else{
        $restlArray=array('data'=>"<b>Error:</b> setup not completed... please contact support"); 
        echo json_encode($restlArray);
        }
        
    }else{
        $restlArray=array('data'=>"<b>Error:</b> transaction already exist.");
        echo json_encode($restlArray);
    }
}else{
$restlArray=array('data'=>"<b>Error:</b> #405894");
echo json_encode($restlArray);
}
?>