function bindPasswordReveal() {
    $('input[type="password"] + .input-group-append').each(function() {
        $(this).on('mousedown touchstart', function() {
            $(this)
                .prev()
                .attr('type', 'text');
        });
        $(this).on('mouseup touchend', function() {
            $(this)
                .prev()
                .attr('type', 'password');
        });
    });
}

function showErrorAlert() {
    $('.alert-form-error:not(.d-block)')
        .removeClass('d-none')
        .addClass('d-block');
}

function hideErrorAlert() {
    $('.alert-form-error')
        .removeClass('d-block')
        .addClass('d-none');
}

function bindInputFocusListener() {
    $('form .form-control')
        .bind('focus', function() {
            $(this)
                .closest('.form-group')
                .addClass('focused');
        })
        .bind('blur', function() {
            $(this)
                .closest('.form-group')
                .removeClass('focused');
        });
}

function bindInputErrorHandler() {
    $('form .form-control')
        .bind('invalid', function(e) {
            showErrorAlert();
            $(this)
                .closest('.form-group')
                .addClass('has-error');
        })
        .bind('change', function(e) {
            if ($(this).is(':valid')) {
                $(this)
                    .closest('.form-group')
                    .addClass('is-valid');
            }

            if ($(this).is(':invalid')) {
                showErrorAlert();
                $(this)
                    .closest('.form-group')
                    .addClass('has-error');
            }
        })
        .bind('keyup', function() {
            $(this)
                .closest('.form-group')
                .removeClass('has-error');
        });
}

window.addEventListener('load', function() {
    bindPasswordReveal();
    bindInputFocusListener();
    bindInputErrorHandler();
});

function required(feilds){
    var splitted=feilds.split(',');
    for (i = 0; i < splitted.length; i++) { 
    var feild_val=$('#'+splitted[i]).val();
    if((feild_val=='') || (feild_val==null)){
      var top=$('#'+splitted[i]).offset().top;
      top=top-150;
      $('#'+splitted[i]).addClass('feild_error'); 
      $('html, body').animate({
        scrollTop: top
      }, 1000); 
      setTimeout(function(){ $('#'+splitted[i]).removeClass('feild_error'); },5000);
      return false 
    }
    }  
}

function validateEmail(e){return/^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/.test(e)}

function login(redirect){
   var username=$("#li_username").val();
   var password=encodeURIComponent($("#li_password").val()); 
   //if($("input:checkbox[name=remeber_me]:checked").length>0){ var remeber_me='Yes'; }else { var remeber_me='No'; }
    
   var dataString ='username='+username+'&password='+password; //+'&remeber_me='+remeber_me;
   if((username!='') && (password!='')){
    
    $('#LoginButton').attr('disabled',true);  
    $('#LoginButton').html('Please wait...').addClass('disabled'); 
    $.ajax({
    url: "REST/verify_login.php",
    type: "POST",
    dataType: "json",
    data: dataString,
    timeout: 120000,
    error: function(xhr, status, error){
    $('#LoginButton').attr('disabled',false); 
    $('#LoginButton').html('Login').removeClass('disabled'); 
    $.notify({ icon: 'fa fa-exclamation-triangle', message: xhr.responseText },{ type: 'danger', timer: 4000, placement: { from: "top", align: "right" } });
    },
    success: function(data){  
    var dataData=data.data;
       
    if(dataData=='Done'){
    if(redirect!='No Redirect'){
    window.location.href=redirect;    
    }else{
    window.location.href='dashboard.php';   
    }
    }else if(dataData=='Pending Verification'){
    var user_email=data.user_email;
    
    $('#LoginButton').attr('disabled',false);
    $('#LoginButton').html('Login').removeClass('disabled');
    $.notify({ icon: 'fa fa-exclamation-triangle', message: 'You need to verify your email address to continue. Click the link below to receive verification link.' },{ type: 'danger', timer: 4000, placement: { from: "top", align: "right" } });
    
    $("#resendTokenCont").show();
    $("#resendTokenBtn").attr("onclick","resendToken('"+user_email+"')");
    }else{
    
    $('#LoginButton').attr('disabled',false);
    $('#LoginButton').html('Login').removeClass('disabled');
    $.notify({ icon: 'fa fa-exclamation-triangle', message: dataData },{ type: 'danger', timer: 4000, placement: { from: "top", align: "right" } });
       
    }

    }
    });
     
   }else{ 
    $.notify({ icon: 'fa fa-exclamation-triangle', message: 'Email and password can\'t be empty' },{ type: 'danger', timer: 4000, placement: { from: "top", align: "right" } }); 
   }
}

function register(redirect){    
 
    var firstname=encodeURIComponent($("#su_firstname").val().trim());  
    var lastname=encodeURIComponent($("#su_lastname").val().trim());  
    var username=$("#su_username").val().trim();  
    var company_name=$("#su_company_name").val().trim();
    var email=$("#su_email").val().trim();
    var password=$("#su_password").val(); 
    var cfrm_password= $("#cfrm_password").val();
    var phone=$("#su_phone").val();
    
    if(validateEmail(email)){ 
    
    if((firstname!='') && (lastname!='') && (username!='') && (company_name!='') && (email!='') && (password!='') && (phone!='')){ 
    if(username.length>5){
    if(password.length>5){
        
    if(!password){ $.notify({ icon: 'fa fa-exclamation-triangle', message: 'Provide a valid password.'},{ type: 'danger', timer: 4000, placement: { from: "top", align: "right" } }); return false; }    
    if(password!=cfrm_password){ $.notify({ icon: 'fa fa-exclamation-triangle', message: 'Password must match.'},{ type: 'danger', timer: 4000, placement: { from: "top", align: "right" } }); return false; }
        
    email=encodeURIComponent(email);
    password=encodeURIComponent(password);
    
    $('#RegisterButton').attr('disabled',true);
    $('#RegisterButton').html('Please wait...').addClass('disabled');      
    var dataString ='firstname='+firstname+'&lastname='+lastname+'&username='+username+'&company_name='+company_name+'&email='+email+'&password='+password+'&phone='+phone;
    //alert(dataString);
    //return false;
    $.ajax({
    url: "REST/register.php",
    type: "POST",
    dataType: "json",
    data: dataString,
    timeout: 120000,
    error: function(xhr, status, error){
    $.notify({ icon: 'fa fa-exclamation-triangle', message: xhr.responseText},{ type: 'danger', timer: 4000, placement: { from: "top", align: "right" } }); 
    $('#RegisterButton').attr('disabled',false);
    $('#RegisterButton').html('Register').removeClass('disabled');   
    },
    success: function(data){
    $('#RegisterButton').attr('disabled',false); 
    $('#RegisterButton').html('Register').removeClass('disabled');      
    var dataData=data.data;
    if(dataData=='Done'){
    if(redirect!='No Redirect'){
    window.location.href=redirect;    
    }else{
    var user_id=data.user_id; 
    window.location.href='verify-your-email.php?email='+email;
    }
    }else{  
    $.notify({ icon: 'fa fa-exclamation-triangle', message: dataData},{ type: 'danger', timer: 4000, placement: { from: "top", align: "right" } });
    } 
    } 
    });   
      
    }else{  
    $.notify({ icon: 'fa fa-exclamation-triangle', message: 'Password can\'t be less than 6 characters'},{ type: 'danger', timer: 4000, placement: { from: "top", align: "right" } }); 
    }   
      
    }else{  
    $.notify({ icon: 'fa fa-exclamation-triangle', message: 'Username can\'t be less than 6 characters'},{ type: 'danger', timer: 4000, placement: { from: "top", align: "right" } }); 
    } 
            
    }else{  
    $.notify({ icon: 'fa fa-exclamation-triangle', message: 'All field are required.'},{ type: 'danger', timer: 4000, placement: { from: "top", align: "right" } }); 
    } 
    }else{
     $.notify({ icon: 'fa fa-exclamation-triangle', message: 'Provide a valid email.'},{ type: 'danger', timer: 4000, placement: { from: "top", align: "right" } }); 
    }  
}


function forgotPassword(redirect){
    var account_email=$("#fp_email").val();
 
    if(validateEmail(account_email)){
    if(account_email!=''){ 
    $('#forgotPwrdButton').attr('disabled',true);
    $('#forgotPwrdButton').html('Please wait...').addClass('disabled'); 
    account_email=encodeURIComponent(account_email);    
    var dataString ='account_email='+account_email;
    //alert(dataString)
    $.ajax({
    url: "REST/sendpassword.php",
    type: "POST",
    dataType: "json",
    data: dataString,
    timeout: 120000,
    error: function(xhr, status, error){
    $('#forgotPwrdButton').attr('disabled',false);
    $('#forgotPwrdButton').html('Request Link').removeClass('disabled');   
    $.notify({ icon: 'fa fa-exclamation-triangle', message: xhr.responseText},{ type: 'danger', timer: 4000, placement: { from: "top", align: "right" } });
    },
    success: function(data){
    $('#forgotPwrdButton').attr('disabled',false);
    $('#forgotPwrdButton').html('Request Link').removeClass('disabled');    
    var dataData=data.data;
    if(dataData=='Password reset link sent to your email.'){ 
    $("#fp_email").val('');    
    $.notify({ icon: 'fa fa-check-circle', message: dataData},{ type: 'success', timer: 4000, placement: { from: "top", align: "right" } });  
    }else{ 
     $.notify({ icon: 'fa fa-exclamation-triangle', message: dataData},{ type: 'danger', timer: 4000, placement: { from: "top", align: "right" } }); 
    }
    
    }
    
    }); 
    }
    
    }else{
      $.notify({ icon: 'fa fa-exclamation-triangle', message: 'Provide a valid email.'},{ type: 'danger', timer: 4000, placement: { from: "top", align: "right" } });
    } 
}


function resetPassword(){
   var account_email=$("#account_email").val();
   var token=$("#token").val();
   var password=$("#rp_password").val();
   var confm_password=$("#cfrm_rp_password").val();
   
   if(password.length<6){
    $.notify({ icon: 'fa fa-exclamation-triangle', message: "Password can't be less than 6 characters." },{ type: 'danger', timer: 4000, placement: { from: "top", align: "right" } });
    return false;
   } 
   
   if(password!=confm_password){ 
    $.notify({ icon: 'fa fa-exclamation-triangle', message: "New password must match!" },{ type: 'danger', timer: 4000, placement: { from: "top", align: "right" } });
    return false;
   } 
   
    $('#ResetButton').attr('disabled',true);
    $('#ResetButton').html('Please wait...').addClass('disabled'); 
    
    if((account_email!='') && (token!='')){ 
    password=encodeURIComponent(password);    
    var dataString ='account_email='+account_email+'&token='+token+'&password='+password;
    //alert(dataString)
    $.ajax({
    url: "REST/update_password.php",
    type: "POST",
    dataType: "json",
    data: dataString,
    timeout: 120000,
    error: function(xhr, status, error){ 
    $('#ResetButton').attr('disabled',false);
    $('#ResetButton').html('Reset Password').removeClass('disabled'); 
    $.notify({ icon: 'fa fa-exclamation-triangle', message: xhr.responseText },{ type: 'danger', timer: 4000, placement: { from: "top", align: "right" }}); 
    },
    success: function(data){
    var dataData=data.data;
    $('#ResetButton').attr('disabled',false);
    $('#ResetButton').html('Reset Password').removeClass('disabled');  
    
    if(dataData=="Password updated succesfully."){
    $.notify({ icon: 'fa fa-exclamation-triangle', message: dataData },{ type: 'success', timer: 4000, placement: { from: "top", align: "right" } });    
    setTimeout(function(){ window.location.href="login.php"; },1500);   
    }else{
     $.notify({ icon: 'fa fa-exclamation-triangle', message: dataData },{ type: 'danger', timer: 4000, placement: { from: "top", align: "right" } });    
    }
      
    }
    
    }); 
    }
}

function resendToken(email){ 
    if(validateEmail(email)){
    $('#ResendButton, #resendTokenBtn').attr('disabled',true);
    $('#ResendButton, #resendTokenBtn').html('Please wait...').addClass('disabled'); 
    
    var dataString ='email='+email;
    //alert(dataString)
    $.ajax({
    url: "REST/resend_token.php",
    type: "POST",
    dataType: "json",
    data: dataString,
    timeout: 120000,
    error: function(xhr, status, error){ 
    $('#ResendButton').attr('disabled',false);
    $('#ResendButton').html('Click To Resend Email').removeClass('disabled'); 
    $.notify({ icon: 'fa fa-exclamation-triangle', message: xhr.responseText },{ type: 'danger', timer: 4000, placement: { from: "top", align: "right" }}); 
    },
    success: function(data){
    var dataData=data.data;
    $('#ResendButton, #resendTokenBtn').attr('disabled',false);
    $('#ResendButton').html('Click To Resend Email').removeClass('disabled'); 
    $('#resendTokenBtn').html('<a href="javascript:;" style="text-decoration: none;">Click here to resend verification email</a>').removeClass('disabled');  
    $("#resendTokenCont").hide();
    
    if(dataData=="Done"){
    $.notify({ icon: 'fa fa-exclamation-triangle', message: "New verification link has been sent to your email address." },{ type: 'success', timer: 4000, placement: { from: "top", align: "right" } });
    }else{
     $.notify({ icon: 'fa fa-exclamation-triangle', message: dataData },{ type: 'danger', timer: 4000, placement: { from: "top", align: "right" } });    
    }
      
    }
    
    });
    
    }else{
      $.notify({ icon: 'fa fa-exclamation-triangle', message: 'Provide a valid email.'},{ type: 'danger', timer: 4000, placement: { from: "top", align: "right" } });
    }
}

function openSideMenu(){
   $("body").css("overflow-y","hidden"); 
   $("#more_menu").addClass("animated slideInRight").show();
   $("#nav_menu li a").css('opacity','0');
}

function closeSideMenu(){
    $("body").css("overflow-y","scroll");
    $("#more_menu").removeClass("animated slideInRight").addClass("animated slideOutRight");
    $("#nav_menu li a").css('opacity','1');
    setTimeout(function(){ $("#more_menu").removeClass("animated slideOutRight").hide();  },650);
}

function load_URL(link){
    window.location.href=link;
}

jQuery.fn.center = function(){
    this.css("position","absolute");
    this.css("top", Math.max(0, (($(window).height() - $(this).outerHeight()) / 2)) + "px");
    this.css("left", Math.max(0, (($(window).width() - $(this).outerWidth()) / 2)) + "px");
    return this;
}

function loginModal(redirectTo){
    closeSigUpModal();
    closeForgotPasswordModal();
    $(".login-modal-full-overlay").remove(); //remove old modal if available
    
    var modal='<div class="login-modal-full-overlay w-100 fleft p-30" style="background-color: rgba(0,0,0,0.5);">\
    <div class="row">\
    <div class="close_prices_cont">\
    <svg xmlns="http://www.w3.org/2000/svg" height="35" width="35" viewBox="0 0 25 25" onclick="closeLoginModal()">\
     <g fill="none" fill-rule="evenodd" stroke="white" stroke-linecap="round" stroke-linejoin="round" stroke-width="3px" transform="translate(1 1)">\
        <path d="M0.5,0.5 L17.4705627,17.4705627" vector-effect="non-scaling-stroke"></path>\
        <path d="M0.5,0.5 L17.4705627,17.4705627" transform="matrix(-1 0 0 1 17.97 0)" vector-effect="non-scaling-stroke"></path>\
     </g>\
    </svg>\
    </div>\
    \
    <div id="modal_inner" class="container pl-0 pr-0 mt-50 mb-50">\
    <div class="float_none centered-text col-xs-12 col-sm-12 col-md-6 col-lg-6">\
    <div class="w-100 fleft p-40" style="background-color: white;">\
    <div class="w-100 fleft pb-20">\
    <h2 class="w-100 mt-0 fleft centered-text">Login</h2>\
    </div>\
    \
    <div class="col-12 fleft p-0 fs-15" style="max-width: 850px;">\
    <div class="fleft w-100">\
    \
    <div class="form-group">\
        <input type="text" placeholder="Username or Email Address" class="form-control" name="li_username" id="li_username" />\
    </div>\
    <div class="form-group">\
        <input type="password" placeholder="Password" class="form-control" name="li_password" id="li_password" />\
    </div>\
    <div class="form-group">\
            <div class="col-xs-12 text_left">\
                <p class="help-block"><a href="javascript:;" class="no-deco" onclick="forgotPasswordModal(\''+redirectTo+'\')" class="text-blue fs-14">Forgot password?</a></p>\
            </div>\
    </div>\
    <div class="form-group">\
        <div class="btn-group-justified">\
            <button class="btn btn-primary brand-bg-color brand-border-color w-100 white p-10 pl-20 pr-20 fw-600 no-radius fs-15" id="LoginButton" onclick="login(\''+redirectTo+'\')">\
            Sign In\
            </button>\
        </div>\
    </div>\
    <p class="help-block fs-14">Don\'t have account? <a href="javascript:;" class="no-deco" onclick="signupModal(\''+redirectTo+'\')" class="text-blue">Sign Up</a></p>\
    \
    </div>\
    </div>\
    \
    </div>\
    </div>\
    \
    </div>\
    </div>\
    </div>';
    $('body').append(modal);
    
    $(".login-modal-full-overlay").show();
    $("#modal_inner").center(); 
    //$('body').scrollTo(0);
    $('body').addClass('body-no-scroll');
}

function closeLoginModal(){
    $(".login-modal-full-overlay").remove();
    //$('body').scrollTo(0);
    $('body').removeClass('body-no-scroll');
    $.notifyClose();
}

function signupModal(redirectTo){
    closeLoginModal();
    closeForgotPasswordModal();
    $(".signup-modal-full-overlay").remove(); //remove old modal if available
    
    var modal='<div class="signup-modal-full-overlay w-100 fleft p-30" style="background-color: rgba(0,0,0,0.5);">\
    <div class="row">\
    <div class="close_prices_cont">\
    <svg xmlns="http://www.w3.org/2000/svg" height="35" width="35" viewBox="0 0 25 25" onclick="closeSigUpModal()">\
     <g fill="none" fill-rule="evenodd" stroke="white" stroke-linecap="round" stroke-linejoin="round" stroke-width="3px" transform="translate(1 1)">\
        <path d="M0.5,0.5 L17.4705627,17.4705627" vector-effect="non-scaling-stroke"></path>\
        <path d="M0.5,0.5 L17.4705627,17.4705627" transform="matrix(-1 0 0 1 17.97 0)" vector-effect="non-scaling-stroke"></path>\
     </g>\
    </svg>\
    </div>\
    \
    <div id="modal_inner" class="container pl-0 pr-0 mt-50 mb-50">\
    <div class="float_none centered-text col-xs-12 col-sm-12 col-md-6 col-lg-6">\
    <div class="w-100 fleft p-40" style="background-color: white;">\
    <div class="w-100 fleft pb-20">\
    <h2 class="w-100 mt-0 fleft centered-text">Sign Up</h2>\
    </div>\
    \
    <div class="col-12 fleft p-0 fs-15" style="max-width: 850px;">\
    <div class="fleft w-100">\
    \
    <div class="w-100">\
    <div class="form-group col-xs-6 pl-0">\
        <input type="text" placeholder="First Name" class="form-control" id="su_firstname" required="" />\
    </div>\
    \
    <div class="form-group col-xs-6 pr-0">\
        <input type="text" placeholder="Last Name" class="form-control" id="su_lastname" required="" />\
    </div>\
    \
    <div class="form-group col-xs-6 pr-0">\
        <input type="text" placeholder="Username" class="form-control" id="su_username" required="" />\
    </div>\
    \
    <div class="form-group col-xs-6 pr-0">\
        <input type="text" placeholder="Company Name" class="form-control" id="su_company_name" required="" />\
    </div>\
    </div>\
    <div class="form-group">\
        <input type="email" placeholder="Email Address" class="form-control" id="su_email" required="" />\
    </div>\
    <div class="form-group">\
        <input type="password" placeholder="Password" class="form-control" id="su_password" required="" />\
    </div>\
    <div class="form-group">\
        <input type="password" placeholder="Confirm Password" class="form-control" id="cfrm_password" required="" />\
    </div>\
    <div class="form-group">\
        <input type="text" placeholder="Phone Number" class="form-control" id="su_phone" required="" />\
    </div>\
    \
    <div class="fleft w-100 centered-text fs-14" style="font-size: 13px!important; margin-bottom: 10px;">\
    By signing up, you agree to the our <a href="privacy.php" class="no-deco" target="_blank">Privacy</a> & <a href="terms.php" class="no-deco" target="_blank">TOS</a>\
    </div>\
    <div class="form-group">\
    <div class="btn-group-justified">\
        <button class="btn btn-primary brand-bg-color brand-border-color w-100 white p-10 pl-20 pr-20 fw-600 no-radius fs-15" id="RegisterButton" onclick="register(\''+redirectTo+'\')">\
        Register\
        </button>\
    </div>\
    </div>\
    <p class="help-block fs-14">Already have an account? <a href="javascript:;" class="no-deco" onclick="loginModal(\''+redirectTo+'\')" class="text-blue">Login Here</a></p>\
    </div>\
    </div>\
    \
    </div>\
    </div>\
    </div>\
    \
    </div>\
    </div>';
    $('body').append(modal);
        
    $(".signup-modal-full-overlay").show();
    $("#modal_inner").center(); 
    //$('body').scrollTo(0);
    $('body').addClass('body-no-scroll');
}

function closeSigUpModal(){
    $(".signup-modal-full-overlay").remove();
    //$('body').scrollTo(0);
    $('body').removeClass('body-no-scroll');
    $.notifyClose();
}


function forgotPasswordModal(redirectTo){
    closeLoginModal();
    closeSigUpModal();
    $(".forgot-password-modal-full-overlay").remove(); //remove old modal if available
    
    var modal='<div class="forgot-password-modal-full-overlay w-100 fleft p-30" style="background-color: rgba(0,0,0,0.5);">\
    <div class="row">\
    <div class="close_prices_cont">\
    <svg xmlns="http://www.w3.org/2000/svg" height="35" width="35" viewBox="0 0 25 25" onclick="closeForgotPasswordModal()">\
     <g fill="none" fill-rule="evenodd" stroke="white" stroke-linecap="round" stroke-linejoin="round" stroke-width="3px" transform="translate(1 1)">\
        <path d="M0.5,0.5 L17.4705627,17.4705627" vector-effect="non-scaling-stroke"></path>\
        <path d="M0.5,0.5 L17.4705627,17.4705627" transform="matrix(-1 0 0 1 17.97 0)" vector-effect="non-scaling-stroke"></path>\
     </g>\
    </svg>\
    </div>\
    \
    <div id="modal_inner" class="container pl-0 pr-0 mt-50 mb-50">\
    <div class="float_none centered-text col-xs-12 col-sm-12 col-md-6 col-lg-6">\
    <div class="w-100 fleft p-40" style="background-color: white;">\
    <div class="w-100 fleft pb-20">\
    <h2 class="w-100 mt-0 fleft centered-text">Password Reset</h2>\
    </div>\
    \
    <div class="col-12 fleft p-0 fs-15" style="max-width: 850px;">\
    <div class="fleft w-100">\
    \
    <div class="form-group">\
        <input type="email" placeholder="Account Email" class="form-control" id="fp_email" />\
    </div>\
    <div class="form-group">\
    <div class="btn-group-justified">\
        <button class="btn btn-primary brand-bg-color brand-border-color w-100 white p-10 pl-20 pr-20 fw-600 no-radius fs-15" id="forgotPwrdButton" onclick="forgotPassword()">\
        Request Link\
        </button>\
    </div>\
    </div>\
    <p class="help-block fs-14">Remeber your password? <a href="javascript:;" class="no-deco" onclick="loginModal(\''+redirectTo+'\')" class="text-blue">Login Here</a></p>\
    </div>\
    </div>\
    \
    </div>\
    </div>\
    \
    </div>\
    \
    </div>\
    </div>';
    $('body').append(modal);
    
    $(".forgot-password-modal-full-overlay").show();
    $("#modal_inner").center(); 
    //$('body').scrollTo(0);
    $('body').addClass('body-no-scroll');
}

function closeForgotPasswordModal(){
    $(".forgot-password-modal-full-overlay").remove();
    //$('body').scrollTo(0);
    $('body').removeClass('body-no-scroll');
    $.notifyClose();
}